/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
* DESCRIPTION
*
* This is the SXI GMD header file.
*
******************************************************************************/
#ifndef SXI_GMD_H_
#define SXI_GMD_H_

#include "standard.h"

#include "sti_api.h"
#include "sxiapi.h"

/**********************/
/** GLOBAL CONSTANTS **/
/**********************/

/*********************/
/** GLOBAL TYPEDEFS **/
/*********************/

typedef struct sxi_gmd_object *SXI_GMD_HDL;
#define SXI_GMD_INVALID_HDL ((SXI_GMD_HDL)NULL)

/*****************************/
/** GLOBAL STRUCT TEMPLATES **/
/*****************************/

/****************************/
/** GLOBAL UNION TEMPLATES **/
/****************************/

/**********************/
/** GLOBAL VARIABLES **/
/**********************/

/*******************/
/** GLOBAL MACROS **/
/*******************/

/***********************/
/** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

SXI_GMD_HDL SXI_GMD_hInit ( void );

void SXI_GMD_vUninit (
    SXI_GMD_HDL hGMD
    );

BOOLEAN SXI_GMD_bDecodeExtGlobalMetadata (
    STI_HDL hControlCxn,
    OSAL_BUFFER_HDL hPayload,
    SXIAPI_EXT_GLOBAL_METADATAIND_STRUCT *psGlobalMetaData
    );

void SXI_GMD_vReleaseDecodedExtGlobalMetadata (
    SXIAPI_RX_UNION *puData
        );

void SXI_GMD_vModuleUpdate (
    STI_HDL hControlCxn,
    SXIAPI_EXT_GLOBAL_METADATAIND_STRUCT *psGlobalMetadata,
    BOOLEAN *pbDispatchToDecoders
    );

void SXI_GMD_vDecoderUpdate (
    DECODER_OBJECT hDecoder,
    STI_HDL hControlCxn,
    SXIAPI_EXT_GLOBAL_METADATAIND_STRUCT *psGlobalMetadata
    );

BOOLEAN SXI_GMD_bConfigure (
    STI_HDL hControlCxn,
    UN64 un64Mask,
    BOOLEAN bEnable
    );

BOOLEAN SXI_GMD_bSetFFTableStatus (
    STI_HDL hControlCxn,
    BOOLEAN bComplete
    );

BOOLEAN SXI_GMD_bGetFFTableStatus (
    STI_HDL hControlCnx
        );

#endif /* SXI_GMD_H_ */
