/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SXI FSM header file.
 *
 ******************************************************************************/
#ifndef SXI_FSM_H_
#define SXI_FSM_H_

#include "standard.h"
#include "osal.h"

#include "srh.h"
#include "sms_api.h"
#include "sms_event_types.h"
#include "sxi_gmd.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct sxi_fsm_object *SXI_FSM_HDL;
#define SXI_FSM_INVALID_HDL ((SXI_FSM_HDL)NULL)

typedef enum radio_module_fsm_event_type_enum
{
    SXI_FSM_EVENT_SELF_TRANSITION,
    SXI_FSM_EVENT_START,
    SXI_FSM_EVENT_TIMEOUT,
    SXI_FSM_EVENT_POWER_CONTROL,
    SXI_FSM_EVENT_RADIO_POWER_STATE,
    SXI_FSM_EVENT_OOB_MSG,
    SXI_FSM_EVENT_MODULE_CFG_IND_RXD,
    SXI_FSM_EVENT_MODULE_ESN_RXD,
    SXI_FSM_EVENT_AUDIO,
    SXI_FSM_EVENT_ERROR

} SXI_FSM_EVENT_TYPE_ENUM;

typedef enum sxi_fsm_power_mode_enum
{
    SXI_FSM_POWER_MODE_ON,
    SXI_FSM_POWER_MODE_OFF,
    SXI_FSM_POWER_MODE_LOW

} SXI_FSM_POWER_MODE_ENUM;

typedef struct sxi_fsm_status_mon_struct
{
    // Signal/antenna status
    BOOLEAN bSignal;
    // Antenna aiming data
    BOOLEAN bAntenna;
    // Audio Presence status
    BOOLEAN bAudioPresence;

} SXI_FSM_STATUS_MON_STRUCT;

typedef struct sxi_fsm_audio_event_struct
{
    // TRUE - Initialize, FALSE - Uninitialize
    BOOLEAN bInitialize;
    // Status Monitors to be enabled
    SXI_FSM_STATUS_MON_STRUCT sStatus;

} SXI_FSM_AUDIO_EVENT_STRUCT;

typedef union sxi_fsm_event_data_union
{
    // MODULE error events
    MODULE_ERROR_CODE_ENUM eModuleErrorCode;

    // Power Mode Event
    SXI_FSM_POWER_MODE_ENUM ePwrMode;

    // STI Protocol OOB event
    STI_PROTOCOL_OOB_STRUCT sOOB;

    // Audio Event
    SXI_FSM_AUDIO_EVENT_STRUCT sAudioEvent;

} SXI_FSM_EVENT_DATA_UNION;

typedef struct sxi_fsm_event_struct
{
    SXI_FSM_EVENT_TYPE_ENUM eEventType;
    SXI_FSM_EVENT_DATA_UNION uEventData;

} SXI_FSM_EVENT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

SXI_FSM_HDL SXI_FSM_hInit (
    const char *pacSRMName,
    OSAL_FILE_STRUCT *psDevice,
    MODULE_OBJECT hModule,
    SRH_DEVICE_CAPABILITIES_MASK tCapabilities,
    STI_HDL *phControlCxn
        );

void SXI_FSM_vUnInit (
    SXI_FSM_HDL hFSM
        );

BOOLEAN SXI_FSM_bPostPowerControl (
    SXI_FSM_HDL hFSM,
    SXI_FSM_POWER_MODE_ENUM ePwrCtrl 
        );

BOOLEAN SXI_FSM_bPostRadioPower (
    SXI_FSM_HDL hFSM,
    SXI_FSM_POWER_MODE_ENUM ePwrMode
        );

BOOLEAN SXI_FSM_bPostCfgIndRxd (
    SXI_FSM_HDL hFSM
        );

BOOLEAN SXI_FSM_bPostEsnRxd (
    SXI_FSM_HDL hFSM
        );

BOOLEAN SXI_FSM_bPostError (
    SXI_FSM_HDL hFSM,
    MODULE_ERROR_CODE_ENUM eModuleErrorCode
        );

BOOLEAN SXI_FSM_bPostOOB (
    SXI_FSM_HDL hFSM,
    STI_PROTOCOL_OOB_STRUCT const *psOOB
        );

BOOLEAN SXI_FSM_bPostAudioEvent (
    STI_HDL hControlCxn,
    SXI_FSM_AUDIO_EVENT_STRUCT const *psAudioEvent
        );

void SXI_FSM_vRun (
    SXI_FSM_HDL hFSM,
    SXI_FSM_EVENT_STRUCT const *psFsmEvent
        );

#endif /* SXI_FSM_H_ */
