/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Traffic/Weather Markets header file.
 * This file must be included once and only once in the appropriate CDO's
 * local header file (_report_obj.h)
 *
 ******************************************************************************/

#ifndef MARKETS_H_
#define MARKETS_H_

#include "report_obj.h"

// Be sure this file is only included by the _sxi_id.h header
#ifdef _SXI_MARKET_ID_H_

  /*********************/
 /** GLOBAL MACROS   **/
/*********************/

// Number of Markets
#define NUM_MARKETS (sizeof(gasMarkets) / sizeof(RADIO_MARKET_STRUCT))

typedef struct radio_market_struct
{
    UN8 un8MarketNum;
    MARKET_STRUCT sMarketInfo;
}RADIO_MARKET_STRUCT;

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// Structure for mapping known Market names and abbreviations
// -- Note -- this will need to get updated as the market table is defined.
static const RADIO_MARKET_STRUCT gasMarkets[] =
{
    //Id,  {Abbr,  Market Name}
    {0, {"ATL", "Atlanta"}},
    {2, {"BAL", "Baltimore"}},
    {3, {"BOS", "Boston"}},
    {6, {"CHI", "Chicago"}},
    {10, {"DFW", "Dallas / Fort Worth"}},
    {12, {"DET", "Detroit"}},
    {15, {"HOU", "Houston"}},
    {19, {"LV",  "Las Vegas"}},
    {20, {"LA",  "Los Angeles"}},
    {23, {"MIA", "Miami"}},
    {25, {"MSP", "Minneapolis / St. Paul"}},
    {29, {"NYC", "New York"}},
    {31, {"ORL", "Orlando"}},
    {32, {"PHL", "Philadelphia"}},
    {33, {"PHX", "Phoenix"}},
    {34, {"PIT", "Pittsburgh"}},
    {41, {"SD",  "San Diego"}},
    {42, {"SF",  "San Francisco"}},
    {43, {"SEA", "Seattle"}},
    {44, {"STL", "St. Louis"}},
    {45, {"TSP", "Tampa / St. Petersburg"}},
    {49, {"DC",  "Washington, DC"}}

};

#endif /* _SXI_MARKET_ID_H_ */

#endif /* MARKETS_H_ */

