/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SXI_ID_H_
#define _SXI_ID_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sxiapi.h"

#include "cid_integer.h"
#include "cid_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SXI_ID_OBJECT_NAME "SXI_ID"


  /**************/
 /** TYPEDEFS **/
/**************/
// SXI ID processing and information interface
typedef struct sxi_id_type_interface_struct
{
    // The CDO type (which makes it a specific CDO)
    CDO_TYPE_ENUM eType;

    // CDO SXI ID Parser
    BOOLEAN (*bParser) (
        CD_OBJECT hCDO,
        const void *pvData
            );

    // The ID describing this CDO
    UN32 un32Id;

} SXI_ID_TYPE_INTERFACE_STRUCT;

  /************/
 /** MACROS **/
/************/
#define SXIAPI_SXI_ID_MAX_LENGTH    sizeof(UN32)

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */
static BOOLEAN bInitializeTypes ( void );

static void vUnInitializeTypes ( void );

  /***************/
 /** VARIABLES **/
/***************/
// This is an initialization of all the SXI_ID interfaces
// we need to create and handle SXI_IDs we support.
static const SXI_ID_TYPE_INTERFACE_STRUCT gasSxiIdIntf[] =
{
    // MUSIC
    {
        /*.eType = */CDO_MUSIC,
        /*.bParser = */NULL,
        /*.un32Id = */'$',
    },

    // REPORT
    {
        /*.eType = */CDO_REPORT,
        /*.bParser = */NULL,
        /*.un32Id = */'*',
    },

    // SPORTS
    {
        /*.eType = */CDO_SPORTS,
        /*.bParser = */NULL,
        /*.un32Id = */'@',
    }

};

// A structure to map an SXI ID parser and info to a CID
typedef struct sxi_id_type_map_struct
{
    // The CID representing this SXI ID
    CID_OBJECT hId;

    // The SXI ID processing and information interface
    const SXI_ID_TYPE_INTERFACE_STRUCT *psIntf;

} SXI_ID_TYPE_MAP_STRUCT;


// Define the number of supported SXI ID types
#define SXI_ID_NUM_TYPES (sizeof(gasSxiIdIntf)/sizeof(SXI_ID_TYPE_INTERFACE_STRUCT))

// SXI ID global structure which maintains pid type maps
// as well as any discovered markets.
typedef struct sxi_id_ctrl_struct
{
    // An array of SXI ID mapping structures based on type
    SXI_ID_TYPE_MAP_STRUCT asTypeMap[SXI_ID_NUM_TYPES];

} SXI_ID_CTRL_STRUCT;

// Local global structure containing all pid type mapping.
static SXI_ID_CTRL_STRUCT gsSxiIdCtrl = {
        {{CID_INVALID_OBJECT, NULL}}
    };

// Global structure defining the CID Interface for SXI ID
// Note: The only method implemented directly by the SXI ID module is
// the bParser(). All the other methods do not exist (NULL)
// Also note that the SXI ID object data is a integer and thus we borrow
// the CID INTEGER interface APIs.
const CID_TYPE_INTERFACE_STRUCT GsSxiId =
{
    // CID type
    /*.eType = */CID_SXI_ID,

    // Init/Unit methods
    /*.bInitialize = */bInitializeTypes,
    /*.vUnInitialize = */vUnInitializeTypes,

    // CID Input Data Parse Method
    /*.bParse = */NULL,

    // Object Data Methods
    /*.sObjData = */{

        // Minimum Expected Size (if known, otherwise 0)
        /*.tMinSize = */MAX_INTEGER_AS_CHARS,
        // Object Data Create/Destroy Methods
        /*.pvCreate = */CIDINT_pvCreate,
        /*.vDestroy = */CIDINT_vDestroy,

        // Object Data Manipulation Methods
        /*.pvDuplicate = */CIDINT_pvDuplicate,
        /*.bModify = */CIDINT_bModify,
        /*.bCopy = */CIDINT_bCopy,
        /*.tSize = */CIDINT_tSize,
        /*.n16Compare = */CIDINT_n16Compare,

        // Object Data I/O Methods
        /*.n32FWrite = */CIDINT_n32FWrite,
        /*.n32FWriteToMemory = */CIDINT_n32FWriteToMemory,
        /*.pvRead = */CIDINT_pvRead,
        /*.bReadFromMemory = */CIDINT_bReadFromMemory,
        /*.n32FPrintf = */CIDINT_n32FPrintf,
        /*.n32GetValue = */CIDINT_n32GetValue
    }
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SXI_ID_H_
