/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SMS_API_DEBUG_H_
#define _SMS_API_DEBUG_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdio.h>

#include "standard.h"

#include "sms_api.h"

#include "sms_api_debug.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Art related string constants
#define LOGO_NAME "Logo"
#define SECONDARY_LOGO_NAME "Secondary Logo"
#define BACKGR0UND_NAME "Background"
#define ALBUMART_NAME "Album"
#define PNG_NAME "PNG"
#define JPG_NAME "JPG"

#define SMS_PRINT_ERROR_MSG_MAX_LEN     (512)    //4 lines of text by 128 characters

// Constants for printing utility function initialization

// SMSAPI_DEBUG_vPrint() outputs debug message
// for level <= DEBUG_PRINT_LEVEL,
// if DEBUG_PRINT_DEFINED_LEVEL_ONLY == FALSE.
#define DEBUG_PRINT_LEVEL               (4)

// SMSAPI_DEBUG_vPrint() outputs debug message
// for level == DEBUG_PRINT_LEVEL,
// if DEBUG_PRINT_DEFINED_LEVEL_ONLY == TRUE.
#define DEBUG_PRINT_DEFINED_LEVEL_ONLY  (FALSE)

// SMSAPI_DEBUG_vPrint() outputs task (thread) ID,
// if DEBUG_PRINT_TASK_ID == TRUE.
#define DEBUG_PRINT_TASK_ID             (FALSE)

// Debug print level to be mandatory put to console (stderr)
#define DEBUG_PRINT_LEVEL_ALWAYS        (0)

// Combination of following options can be used to set
// value of DEBUG_PRINT_OUTPUT_OPTIONS using '|' statement.
// If the following option is specified,
// SMSAPI_DEBUG_vPrint() will output logs to standard output.
#define DEBUG_PRINT_OPTION_STD_OUTPUT   (1)
// If the following option is specified,
// SMSAPI_DEBUG_vPrint() will output logs
// to the file located in the SMS temp folder.
// File name is specified by DEBUG_PRINT_FILE_NAME.
#define DEBUG_PRINT_OPTION_FILE_OUTPUT  (2)

// Should be specified as a combination
// of DEBUG_PRINT_OPTION_... values using '|' statement.
#define DEBUG_PRINT_OUTPUT_OPTIONS      (DEBUG_PRINT_OPTION_STD_OUTPUT)

// Name of the output file created in the SMS temp folder
#define DEBUG_PRINT_FILE_NAME           "/sms_log.txt"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct smsapi_debug_ccache_channel_iterator_struct
{
    N16 n16NumChannels;
    N16 n16NumSubscribedChannels;
    N16 n16NumUnSubscribedChannels;

    CHANNEL_OBJECT_PRINT_MODE_ENUM eMode;

} SMSAPI_DEBUG_CCACHE_CHANNEL_ITERATOR_STRUCT;

typedef struct smsapi_debug_ccache_category_iterator_struct
{
    N16 n16NumCategories;
    BOOLEAN bVerbose;

} SMSAPI_DEBUG_CCACHE_CATEGORY_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

#define LINE(x) { \
    size_t tIndex; \
    for(tIndex = (x); tIndex--;) \
        printf("="); \
    puts(""); \
}

  /****************/
 /** PROTOTYPES **/
/****************/

static void vPrintCategoryArtCallback(
    CHANNEL_ART_OBJECT hArt,
    CHANNEL_ART_AVAILABLE_IMAGE_MASK tAvailableImages,
    void *pvCategoryArtAccessCallbackArg
        );

static N16 n16PrintChannelIterator(
    CATEGORY_OBJECT hCategory,
    CATEGORY_CHANNEL_INDEX tCurrentIndex,
    CHANNEL_OBJECT hChannel,
    void *pvIterateArg
        );

static void vPrintChannelArtCallback(
    CHANNEL_ART_OBJECT hArt,
    CHANNEL_ART_AVAILABLE_IMAGE_MASK tAvailableImages,
    void *pvChannelArtAccessCallbackArg
        );

static void vPrintContentArtCallback(
    CHANNEL_ART_OBJECT hArt,
    CHANNEL_ART_AVAILABLE_IMAGE_MASK tAvailableImages,
    void *pvChannelArtAccessCallbackArg
        );

static const char *pacLeagueEnumText(
    LEAGUE_ENUM eType
        );

#if SMS_DEBUG == 1
static BOOLEAN bPrintSongIterator(
    SONG_OBJECT hSong,
    void *pvArg
        );
#endif

static void vPrintSongs (
    SCACHE_OBJECT hSCache,
    BOOLEAN bVerbose
        );

static BOOLEAN bPrintSimilarChannels(
    CHANNEL_OBJECT hChannel,
    void *pvArg
        );

static BOOLEAN bPrintEpgEvents(
    PROGRAM_OBJECT hEpgEvent,
    void *pvArg
    );

  /***************/
 /** VARIABLES **/
/***************/

// Used by SMSAPI_DEBUG_vPrint function to define print levels to be put
// to console
static UN8 un8DebugPrintLevel;
// Used by SMSAPI_DEBUG_vPrint function to signal that only one specific
// print level is to be typed out
static BOOLEAN bDebugPrintSpecifiedLevelOnly;
// Used by SMSAPI_DEBUG_vPrint function to signal that task ID is to be
// printed
static BOOLEAN bDebugPrintTaskID;

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SMS_API_DEBUG_H_
