/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the sms api debug header file.
 *
 ******************************************************************************/
#ifndef SMS_API_DEBUG_H_
#define SMS_API_DEBUG_H_

#include "standard.h"
#include "osal.h"
#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#if SMS_DEBUG == 0

#ifdef SMSAPI_DEBUG_vPrintErrorFull
#undef SMSAPI_DEBUG_vPrintErrorFull
#endif

#if __STDC_VERSION__ >= 199901L
#define SMSAPI_DEBUG_vPrintErrorFull(...)
#else
#define SMSAPI_DEBUG_vPrintErrorFull if(1);else SMSAPI_DEBUG_vPrintErrorDummy
#endif

#ifdef SMSAPI_DEBUG_vPrint
#undef SMSAPI_DEBUG_vPrint
#endif

#if __STDC_VERSION__ >= 199901L
#define SMSAPI_DEBUG_vPrint(...)
#else
#define SMSAPI_DEBUG_vPrint if(1);else SMSAPI_DEBUG_vPrintDummy
#endif

#endif /* SMS_DEBUG == 0 */

// Output text colors for SMSAPI_DEBUG_vPrint() (for Linux only)
#ifdef LINUX
#define PC_RED   "\033[1;31m"
#define PC_BLUE  "\033[1;34m"
#define PC_GREEN "\033[1;32m"
#define PC_GREY  "\033[1;30m"
#define PC_CYAN  "\033[1;36m"
#define PC_RESET "\033[0;00m"
#else /* #ifdef LINUX */
#define PC_RED   ""
#define PC_BLUE  ""
#define PC_GREEN ""
#define PC_GREY  ""
#define PC_CYAN  ""
#define PC_RESET ""
#endif /* #ifdef LINUX ... #else ... */

// These are the lengths of channel, category, artist and title
// fields that we are interested in displaying.
#define SMS_SHORT_CHANNEL_NAME_MAX_LENGTH    (8)
#define SMS_MEDIUM_CHANNEL_NAME_MAX_LENGTH  (10)
#define SMS_LONG_CHANNEL_NAME_MAX_LENGTH    (20)
#define SMS_SHORT_CATEGORY_NAME_MAX_LENGTH   (8)
#define SMS_MEDIUM_CATEGORY_NAME_MAX_LENGTH (10)
#define SMS_LONG_CATEGORY_NAME_MAX_LENGTH   (20)
#define SMS_SHORT_DESCRIPTION_MAX_LENGTH    (36)
#define SMS_LONG_DESCRIPTION_MAX_LENGTH    (180)
#define SMS_ARTIST_NAME_MAX_LENGTH          (36)
#define SMS_TITLE_NAME_MAX_LENGTH           (36)
#define SMS_COMPOSER_NAME_MAX_LENGTH        (36)
#define SMS_ALBUM_NAME_MAX_LENGTH           (36)
#define SMS_CONTENTINFO_NAME_MAX_LENGTH     (36)
#define SMS_PATH_MAX_LENGTH                 (64)
#define SMS_CATEGORY_SHORT_NAME_MAX_LEN      (8)
#define SMS_CATEGORY_MEDIUM_NAME_MAX_LEN    (10)
#define SMS_CATEGORY_LONG_NAME_MAX_LEN      (16)
#define SMS_MAX_SPORTS_TEAM_ABBREV           (6)
#define SMS_MAX_TRACK_NUM_TEAMS              (2)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef enum channel_object_print_mode_enum
{
    CHANNEL_OBJECT_PRINT_TERSE,
    CHANNEL_OBJECT_PRINT_VERBOSE,
    CHANNEL_OBJECT_PRINT_GROSS

} CHANNEL_OBJECT_PRINT_MODE_ENUM;

typedef struct channel_art_image_info_struct
{
    // Image attributes
    STRING_OBJECT hFilename;
    char acFilename[SMS_PATH_MAX_LENGTH + 1];
    IMAGE_FORMAT_ENUM eFormat;
    char acFormat[4];
    char acImageType[16];
    size_t tFileSizeInBytes;
    RGB_STRUCT sBkgrndColor;
    BOOLEAN bUseBkgrndColor;
    BOOLEAN bUseLineBitmap;
    BOOLEAN bUsingDefault;
    size_t tLineBitmapSize;

} CHANNEL_ART_IMAGE_INFO_STRUCT;

typedef struct channel_art_info_struct
{
    CHANNEL_ART_AVAILABLE_IMAGE_MASK tAvailableImages;
    CHANNEL_ART_IMAGE_INFO_STRUCT sBackgroundInfo;
    CHANNEL_ART_IMAGE_INFO_STRUCT sLogoInfo;
    CHANNEL_ART_IMAGE_INFO_STRUCT sSecondaryLogoInfo;
    CHANNEL_ART_IMAGE_INFO_STRUCT sAlbumInfo;

} CHANNEL_ART_INFO_STRUCT;

typedef struct category_art_info_struct
{
    CHANNEL_ART_AVAILABLE_IMAGE_MASK tAvailableImage;
    char acImageType[11];
    char acImageFilename[SMS_PATH_MAX_LENGTH];
    char acImageFormat[4];
    BOOLEAN bUsingDefault;

} CATEGORY_ART_INFO_STRUCT;


typedef struct channel_info_struct
{
    CHANNEL_OBJECT hChannel;
    CHANNEL_ID tChannelId;
    char acChannelId[6];
    STRING_OBJECT hChannelLongName;
    char acChannelLongName[SMS_LONG_CHANNEL_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hChannelMediumName;
    char acChannelMediumName[SMS_MEDIUM_CHANNEL_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hChannelShortName;
    char acChannelShortName[SMS_SHORT_CHANNEL_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hChannelLongDesc;
    char acChannelLongDesc[SMS_LONG_DESCRIPTION_MAX_LENGTH + 1];
    STRING_OBJECT hChannelShortDesc;
    char acChannelShortDesc[SMS_SHORT_DESCRIPTION_MAX_LENGTH + 1];

    SERVICE_ID tServiceId;
    char acServiceId[6];

    CATEGORY_OBJECT hCategory;
    STRING_OBJECT hCategoryLongName;
    char acLongCategoryName[SMS_LONG_CATEGORY_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hCategoryMediumName;
    char acMediumCategoryName[SMS_MEDIUM_CATEGORY_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hCategoryShortName;
    char acShortCategoryName[SMS_SHORT_CATEGORY_NAME_MAX_LENGTH + 1];
    CATEGORY_ID tCategoryId;
    char acCategoryId[6];
    CATEGORY_ART_INFO_STRUCT sCategoryArtInfo;

    CD_OBJECT hCDO;

    STRING_OBJECT hTitleName;
    char acTitleName[SMS_TITLE_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hArtistName;
    char acArtistName[SMS_ARTIST_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hComposerName;
    char acComposerName[SMS_COMPOSER_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hAlbumName;
    char acAlbumName[SMS_ALBUM_NAME_MAX_LENGTH + 1];
    STRING_OBJECT hContentInfoName;
    char acContentInfoName[SMS_CONTENTINFO_NAME_MAX_LENGTH + 1];

    CHANNEL_ART_INFO_STRUCT sContentArtInfo;

    BOOLEAN bSubscribed;
    BOOLEAN bLocked;
    BOOLEAN bSkipped;
    BOOLEAN bMature;
    BOOLEAN bFreeToAir;
    CHANNEL_PLAY_ON_SELECT_METHOD_ENUM ePlayOnSelect;

    CHANNEL_ART_INFO_STRUCT sChannelArtInfo;

    PRESET_BAND_OBJECT hPresetBand;
    char acPresetBandName[OSAL_MAX_OBJECT_NAME_LENGTH_WITH_NULL];
    STRING_OBJECT hPresetName;
    char acPresetName[OSAL_MAX_OBJECT_NAME_LENGTH_WITH_NULL];
    size_t tPresetIndex;
    char acPresetIndex[16];

    CHANNEL_ACO tACO;

} CHANNEL_INFO_STRUCT;


  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

// Macro to decode Attribute status into text
#define ATTRIBUTE_STATE_TEXT(bAttribute)     \
    (                                        \
        (bAttribute == TRUE) ?               \
        "Yes" :                              \
        "No"                                 \
    )


  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

const char *SMSAPI_DEBUG_pacReturnCodeText(
    SMSAPI_RETURN_CODE_ENUM eReturnCode
        );

BOOLEAN LEAGUE_DEBUG_bPrint (
    LEAGUE_OBJECT hLeague,
    void *pvContentIteratorCallbackArg
        );

void SONG_vPrint (
    SONG_OBJECT hSong,
    BOOLEAN bVerbose
        );

BOOLEAN TEAM_bPrint (
    TEAM_OBJECT hTeam,
    LEAGUE_OBJECT hLeague,
    void *pvContentIteratorCallbackArg
        );

BOOLEAN CCACHE_DEBUG_bPrintChannelIterator (
    CHANNEL_OBJECT hChannel,
    void *pvArg
        );

BOOLEAN CCACHE_DEBUG_bPrintCategoryIterator (
    CATEGORY_OBJECT hCategory,
    void *pvArg
        );

void CATEGORY_DEBUG_vPrint (
    CATEGORY_OBJECT hCategory,
    BOOLEAN bVerbose
        );

void CHANNEL_DEBUG_vPrint (
    CHANNEL_OBJECT hChannel,
    CHANNEL_OBJECT_PRINT_MODE_ENUM eMode
        );

const char *CHANNEL_DEBUG_pacPlayOnSelectMethod(
    CHANNEL_PLAY_ON_SELECT_METHOD_ENUM ePlayOnSelectMethod
        );

void CHANNEL_DEBUG_vPrintInfo (
    CHANNEL_INFO_STRUCT *psInfo,
    CHANNEL_OBJECT_PRINT_MODE_ENUM eMode
        );

void DECODER_DEBUG_vError(
    DECODER_OBJECT hDecoder
        );

void DECODER_DEBUG_vPrintCCache (
    DECODER_OBJECT hDecoder,
    BOOLEAN bChannels,
    BOOLEAN bCategories,
    BOOLEAN bVerbose
        );

void DECODER_DEBUG_vPrintSCache (
    DECODER_OBJECT hDecoder,
    BOOLEAN bVerbose
        );

void DECODER_DEBUG_vPrintTuneScan (
    DECODER_OBJECT hDecoder
        );

void CME_DEBUG_vPrintContent (
    DECODER_OBJECT hDecoder,
    FILE *psFile
        );

const char *CDO_pacEnumText(
    CDO_TYPE_ENUM eType
        );

void PLAYBACK_vPrintSongs(
    PLAYBACK_OBJECT hPlayback,
    BOOLEAN bVerbose
        );

const char *SPORTS_pacEnumText(
    SPORTS_ENUM eType
        );

const char *SPORTS_pacBCastEnumText(
    SPORTS_BROADCAST_ENUM eType
        );

SMSAPI_RETURN_CODE_ENUM CM_DEBUG_ePrint(
    void
        );

SMSAPI_RETURN_CODE_ENUM DEVICE_DEBUG_ePrint(
    void
        );

const char *SONG_pacStatusText(
    SMSAPI_SONG_STATUS_ENUM eStatus
        );

const char *SCAN_pacCmdText (
    DECODER_TUNE_SCAN_CMD_ENUM eTuneScanCmd
        );

BOOLEAN SRM_bSetError (
    SRM_OBJECT hSRM,
    SRM_ERROR_CODE_ENUM eErrorCode
        );

BOOLEAN MODULE_bSetError (
    MODULE_OBJECT hModule,
    MODULE_ERROR_CODE_ENUM eErrorCode
        );

BOOLEAN DECODER_bSetError (
    DECODER_OBJECT hDecoder,
    DECODER_ERROR_CODE_ENUM eErrorCode
        );

void SMSAPI_DEBUG_vPrintChannels (
    DECODER_OBJECT hDecoder,
    BOOLEAN bVerbose
        );

void SMSAPI_DEBUG_vPrintCategories (
    DECODER_OBJECT hDecoder,
    BOOLEAN bVerbose
        );

#if __STDC_VERSION__ < 199901L
void SMSAPI_DEBUG_vPrintErrorDummy (
    const char *pcThisFile,
    UN32 un32LineNum,
    const char *pcMessage,
    ...
        );
#endif /* __STDC_VERSION__ < 199901L */

#if SMS_DEBUG != 0
void SMSAPI_DEBUG_vPrintErrorFull (
    const char *pcThisFile,
    UN32 un32LineNum,
    const char *pcMessage,
    ...
        );
#endif /* #if SMS_DEBUG != 0 */

void SMSAPI_DEBUG_vPrintDummy (
    const char *pcPrefix,
    UN8 un8Level,
    char *pcText,
    ...
    );

#ifndef SMSAPI_DEBUG_vPrint

void SMSAPI_DEBUG_vPrint (
    const char *pcPrefix,
    UN8 un8Level,
    char *pcText,
    ...
        );

#endif  /*SMSAPI_DEBUG_vPrint*/

#if (SMS_DEBUG == 1) || (__STDC_VERSION__ < 199901L)

char const *SMSAPI_DEBUG_pacSRMErrorCodeText(
    SRM_ERROR_CODE_ENUM eError
        );

char const *SMSAPI_DEBUG_pacModuleErrorCodeText(
    MODULE_ERROR_CODE_ENUM eError
        );

char const *SMSAPI_DEBUG_pacDecoderErrorCodeText(
    DECODER_ERROR_CODE_ENUM eError
        );

#endif

void SMSAPI_DEBUG_vSetPrintLevel(
    UN8 un8PrintLevel
        );

void SMSAPI_DEBUG_vSetPrintSpecifiedLevelOnly(
    BOOLEAN bOneLevelOnly
        );

void SMSAPI_DEBUG_vSetPrintTaskID(
    BOOLEAN bPrintTaskID
        );

void SMSAPI_DEBUG_vInitPrintingParameters( void );

#if 0
float SMSAPI_DEBUG_fFixed2Float(OSAL_FIXED_OBJECT hFixed);
#endif

#endif /* SMS_API_DEBUG_H_*/

