/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Presets debug header file.
 *
 ******************************************************************************/

#ifndef PRESETS_DEBUG_H_
#define PRESETS_DEBUG_H_

#include "standard.h"
#include "sms_api.h"

#include "presets_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct presets_debug_attrs_struct
{
    // The presets service handle
    PRESETS_OBJECT hPresets;

    // The presets service name attributes
    STRING_OBJECT hLongName;
    STRING_OBJECT hShortName;

    // The category associated with the presets service
    CATEGORY_ID tCategoryId;

    // Current Band Syncronization Category Id
    CATEGORY_ID tCategorySyncId;

    // The number of band and the band
    // list associated with the presets service
    size_t tNumberOfBands;
    OSAL_OBJECT_HDL hBandList;

    // Featured Favorites Status
    BOOLEAN bFeaturedFavoritesEnabled;

} PRESETS_DEBUG_ATTRS_STRUCT;

typedef struct presets_debug_band_attr_struct
{
    // The band handle
    PRESET_BAND_OBJECT hBand;

    // Unique ID of each band in the service
    size_t tBandId;

    // The band's name
    STRING_OBJECT hName;

    // The band's long name
    STRING_OBJECT hLongName;

    // The band's verbose name
    STRING_OBJECT hVerbose;

    // The band's description
    STRING_OBJECT hDescription;

    // Indicate that this band was loaded from broadcast
	PRESET_BAND_TYPE_ENUM eType;

    // Signifying the relative ordering of the
	// Featured Favorites banks provided by a service
	// Unique index for the received featured favorites
    FAVORITES_BAND_ORDER tOrder;

    // Unique ID
    FAVORITES_BAND_ID tId;

    // cycles from 0 ... 15, 0 ... each time an existing
	// bank is modified (identified by Bank ID)
    FAVORITES_BAND_SEQUENCE tSequence;

    // Indicates a purpose of a bank
    FAVORITES_BAND_PURPOSE_MASK tPurpose;

    // The number of presets this band contains
    size_t tCapacity;

    // State of Band
    BOOLEAN bRemoved;

    // Current Band sign
    BOOLEAN bCurrent;

} PRESETS_DEBUG_BAND_ATTR_STRUCT;

typedef struct presets_debug_preset_attr_struct
{
    size_t tPresetIndex;
    STRING_OBJECT hName;
    STRING_OBJECT hChannelName;
    SERVICE_ID tServiceId;
    CHANNEL_ID tChannelId;

} PRESETS_DEBUG_PRESET_ATTR_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Friend Prototypes */
N32 PRESETS_DEBUG_n32PrintPresetsService (
    PRESETS_DEBUG_ATTRS_STRUCT *psPresetsAttr,
    FILE *psFile
        );

N32 PRESETS_DEBUG_n32PrintBand (
    PRESETS_DEBUG_BAND_ATTR_STRUCT *psBandAttr,
    FILE *psFile,
    const char *pacFormat
        );

N32 PRESETS_DEBUG_n32PrintPreset (
    PRESETS_DEBUG_PRESET_ATTR_STRUCT *psPresetAttr,
    FILE *psFile,
    const char *pacFormat
        );

#endif /* PRESETS_DEBUG_H_*/

