////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_receiver\rfdr_processor_simple_code.c
///
/// @brief	rfdr processor for simple-code class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////


#include "rfd_receiver.h"
#include "rfd_codec_xcc.h"

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFD_DecodeInfoSimpleCodeCreateWithDefInit( RFDR_FILE_PROCESS_INFO * fileProcessInfo )
{
	RFD_STATUS status;
	// Call generic XccCode initialization.
	status = RFD_DecodeInfoXccCodeCreateWithDefInit( fileProcessInfo );
	return status;
}

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS  RFD_DecodeInfoSimpleCodeReadFromStorage( TCHAR * pathBuf, RFDR_FILE_PROCESS_INFO * fileProcessInfo )
{
	RFD_STATUS status;
	// Use generic Xcc code funtion.
	status = RFD_DecodeInfoXccCodeReadFromStorage( pathBuf, fileProcessInfo );
	return status;
}

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS  RFD_DecodeInfoSimpleCodeWriteToStorage( TCHAR * pathBuf, RFDR_FILE_PROCESS_INFO * fileProcessInfo )
{
	RFD_STATUS status;
	// Use generic Xcc code funtion.
	status = RFD_DecodeInfoXccCodeWriteToStorage( pathBuf, fileProcessInfo );
	return status;
}

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS  RFD_DecodeInfoSimpleCodeCleanupStorage( TCHAR * pathBuf, RFDR_FILE_PROCESS_INFO * fileProcessInfo )
{
	RFD_STATUS status;
	// Use generic Xcc code funtion.
	status = RFD_DecodeInfoXccCodeCleanupStorage( pathBuf, fileProcessInfo );
	return status;
}

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFDR_PrepareForDecodeSimpleCode(const TCHAR pathBuf[], RFDR_FILE_PROCESS_INFO * fileProcessInfo, BOOL doStorageOpsOnly)
{
	RFD_STATUS status;
	// Use the generic 'Xcc' code prepare function for the Simple Code.
	status = RFDR_PrepareForDecodeXccCode(pathBuf, fileProcessInfo, doStorageOpsOnly);
	return status;
}


///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFDR_PostDecodeOpsSimpleCode(const TCHAR pathBuf[], RFDR_FILE_PROCESS_INFO * fileProcessInfo, BOOL * pIsDecodeComplete)
{
	RFD_STATUS status;
	// Use generic Xcc function
	status = RFDR_PostDecodeOpsXccCode(pathBuf, fileProcessInfo, pIsDecodeComplete);
	return status;
}

///////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFDR_CollectBlockSimpleCode(const TCHAR * pathBuf, RFDR_FILE_PROCESS_INFO * fileProcessInfo, RFD_BLOCK_MSG_STRUCT * hBlockMsg, BOOL * pSignalRequest)
{
	RFD_STATUS status;
	// Use generic Xcc code.
	status = RFDR_CollectBlockXccCode(pathBuf, fileProcessInfo, hBlockMsg, pSignalRequest);
	return status;
}

///////////////////////////////////////////////////////////////////////////////////////////////
BOOL RFDR_IsMaxAllowableNumBlocksCollectedSimpleCode(RFDR_DECODE_INFO * decodeInfo)
{
	BOOL isMaxAllowableNumBlocksCollected;
	// Call generic XccCode function.
	isMaxAllowableNumBlocksCollected = RFDR_IsMaxAllowableNumBlocksCollectedXccCode( decodeInfo );
	return isMaxAllowableNumBlocksCollected;
}

///////////////////////////////////////////////////////////////////////////////////////////////
BOOL RFDR_IsBlockCollectionStateReadyForDecodeSimpleCode(RFDR_DECODE_INFO * decodeInfo)
{
	BOOL isReadyForDecode;
	// Call generic XccCode function.
	isReadyForDecode = RFDR_IsBlockCollectionStateReadyForDecodeXccCode( decodeInfo );
	return isReadyForDecode;
}

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFDR_GetDecoderSolutionStatsSimpleCode(RFDR_FILE_PROCESS_INFO * fileProcessInfo, RFDR_DECODE_STATS * decodeStats)
{
	RFD_STATUS status;
	// Use generic Xcc function
	status = RFDR_GetDecoderSolutionStatsXccCode(fileProcessInfo, decodeStats);
	return status;
}

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFD_InitializeDecodeBlockThresholdInfoSimpleCode(RFD_XCC_DECODE_EVENT_BLOCK_THRESH_INFO * decodeBlockThresholdInfo)
{
	decodeBlockThresholdInfo->blockThresholdNumeratorArray[0] = RFD_SIMPLE_DECODE_CHUNK_BLK_THRESH_DENOM;
	decodeBlockThresholdInfo->numeratorArrayLen = RFD_SIMPLE_DECODE_NUM_DECODE_CHUNKS;
	decodeBlockThresholdInfo->blockThreshDenominator = RFD_SIMPLE_DECODE_CHUNK_BLK_THRESH_DENOM;
	decodeBlockThresholdInfo->extraBlocksIncrement = RFD_SIMPLE_DECODE_EXTRA_BLKS_CHUNK_INC;

	return RFD_STATUS_OK;
}
