////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file    rfd_receiver\rfd_receiver_config.c
///
/// @brief    rfd receiver configuration.
///
/// @remarks    Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks    Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#include "rfd_receiver.h"
#include "_rfd_receiver_config.h"

const RFD_DECODE_XCC_FILE_NAME_LIST gDecodeXccFileNameList =
    {
        RFDR_SRC_BLKS_INBUF_TMP_DECODE_FNAME,        // srcBlksInbufFileName
        RFDR_CHK_BLKS_INBUF_TMP_DECODE_FNAME,        // chkBlksInbufFileName
        RFDR_XCC_DEC_EQU_INFO_FNAME,                // transformationInfoFileName
        RFDR_XCC_DEC_COEFF_TRANS_MATRIX_FNAME,        // coeffTransformFileName
        RFDR_XCC_DEC_BLOCK_TRANS_MATRIX_FNAME,        // blockTransformFileName
        RFDR_DECODE_OUTPUT_FNAME                    //
    };


///////
// Structures for the File Consumer threads.
///////

TCHAR * gFileConsumerDirName[RFDR_NUM_CLIENTS] =
                {
                      RFD_FILE_CONSUMER_0_DIR_NAME
                    #if (RFDR_NUM_CLIENTS > 1)
                    , RFD_FILE_CONSUMER_1_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 2)
                    , RFD_FILE_CONSUMER_2_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 3)
                    , RFD_FILE_CONSUMER_3_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 4)
                    , RFD_FILE_CONSUMER_4_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 5)
                    , RFD_FILE_CONSUMER_5_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 6)
                    , RFD_FILE_CONSUMER_6_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 7)
                    , RFD_FILE_CONSUMER_7_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 8)
                    , RFD_FILE_CONSUMER_8_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 9)
                    , RFD_FILE_CONSUMER_9_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 10)
                    #error "add entries as necessary for additional clients."
                    #endif
                };

///////
// Structures for the Processor thread.
///////

DWORD gClientId[RFDR_NUM_CLIENTS] =
                {
                      RFDR_CLIENT_0_ID
                    #if (RFDR_NUM_CLIENTS > 1)
                    , RFDR_CLIENT_1_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 2)
                    , RFDR_CLIENT_2_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 3)
                    , RFDR_CLIENT_3_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 4)
                    , RFDR_CLIENT_4_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 5)
                    , RFDR_CLIENT_5_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 6)
                    , RFDR_CLIENT_6_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 7)
                    , RFDR_CLIENT_7_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 8)
                    , RFDR_CLIENT_8_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 9)
                    , RFDR_CLIENT_9_ID
                    #endif
                    #if (RFDR_NUM_CLIENTS > 10)
                    #error "add entries as necessary for additional clients."
                    #endif

                };

TCHAR * gClientDirName[RFDR_NUM_CLIENTS] =
                {
                      RFDR_CLIENT_0_DIR_NAME
                    #if (RFDR_NUM_CLIENTS > 1)
                    , RFDR_CLIENT_1_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 2)
                    , RFDR_CLIENT_2_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 3)
                    , RFDR_CLIENT_3_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 4)
                    , RFDR_CLIENT_4_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 5)
                    , RFDR_CLIENT_5_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 6)
                    , RFDR_CLIENT_6_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 7)
                    , RFDR_CLIENT_7_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 8)
                    , RFDR_CLIENT_8_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 9)
                    , RFDR_CLIENT_9_DIR_NAME
                    #endif
                    #if (RFDR_NUM_CLIENTS > 10)
                    #error "add entries as necessary for additional clients."
                    #endif
                };

///////
// Structures for the Collector threads.
///////

RFD_MESSAGE_CONFIG_INFO gMessageConfigInfo[RFDR_NUM_CLIENTS] = {
    {
        RFDR_CLIENT_0_MSG_PROTOCOL_VERSION_NUM,        // Protocol Version Number
        RFDR_CLIENT_0_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,   // Number of bits for the Carousel Id field.
        RFDR_CLIENT_0_FILE_SET_MSG_CAR_FIELD_SIZE_BITS,  // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_0_FILE_SET_MSG_CAROUSEL_ID,     // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_0_MAX_BLOCK_LEN_BYTES,             // Maximum length of a Block.
        RFDR_CLIENT_0_MAX_FILE_LEN_BYTES,             // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID     // Carousel ID for the Block type message.
    }
    #if (RFDR_NUM_CLIENTS > 1)
    ,
    {
        RFDR_CLIENT_1_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_1_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_1_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_1_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_1_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_1_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 2)
    ,
    {
        RFDR_CLIENT_2_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_2_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_2_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_2_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_2_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_2_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 3)
    ,
    {
        RFDR_CLIENT_3_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_3_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_3_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_3_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_3_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_3_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 4)
    ,
    {
        RFDR_CLIENT_4_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_4_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_4_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_4_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_4_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_4_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 5)
    ,
    {
        RFDR_CLIENT_5_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_5_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_5_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_5_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_5_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_5_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 6)
    ,
    {
        RFDR_CLIENT_6_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_6_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_6_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_6_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_6_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_6_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 7)
    ,
    {
        RFDR_CLIENT_7_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_7_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_7_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_7_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_7_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_7_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 8)
    ,
    {
        RFDR_CLIENT_8_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_8_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_8_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_8_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_8_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_8_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 9)
    ,
    {
        RFDR_CLIENT_9_MSG_PROTOCOL_VERSION_NUM,            // Protocol Version Number
        RFDR_CLIENT_9_MSG_CAROUSEL_ID_FIELD_SIZE_BITS,    // Number of bits for the Carousel Id field.
        RFDR_CLIENT_9_FILE_SET_MSG_CAR_FIELD_SIZE_BITS, // Number of bits for the (Dynamic Block) CAR field of the FSET message
        RFDR_CLIENT_9_FILE_SET_MSG_CAROUSEL_ID,         // Carousel ID for the File Set Metadata message.
        RFDR_CLIENT_9_MAX_BLOCK_LEN_BYTES,                 // Maximum length of a Block.
        RFDR_CLIENT_9_MAX_FILE_LEN_BYTES,                // Maximum length of an individual file of a file set.
        RFDR_CLIENT_INITIAL_BLOCK_MSG_CAROUSEL_ID         // Carousel ID for the Block type message.
    }
    #endif
    #if (RFDR_NUM_CLIENTS > 10)
    #error "add entries as necessary for additional clients."
    #endif
};

