////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_receiver\rfd_msg_collector.h
///
/// @brief	Declares the rfd message collector class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RFD_FILE_COLLECTOR_H
#define RFD_FILE_COLLECTOR_H

#include "rfd_config.h"
#include "rfd_receiver.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

///////////////////////////////////////////////////////////////////////////////
DWORD RFD_PLATFORM_API RFDR_MsgCollector( LPVOID lpParam ) ;

RFD_STATUS RFD_CollectorPutMessage(RFD_COLLECTOR_THREAD_DATA_HANDLE collectorHandle, UCHAR * messageBuf, UINT32 messageSize);

RFD_STATUS RFD_CollectorIsMessageCollectable(RFD_COLLECTOR_THREAD_DATA_HANDLE collectorHandle, UCHAR * messageBuf, UINT32 messageSize);

RFD_STATUS RFD_CollectorIsMessageCollectableExt(
    RFD_COLLECTOR_THREAD_DATA_HANDLE collectorHandle,
    UCHAR * messageBuf,
    UINT32 messageSize,
    BOOL filterBlkMsgFileId,
    BOOL filterBlkMsgDmi,
    UINT16 blkMsgDmi );

RFD_STATUS RFD_CollectorGetDefaultMessageConfig(
                RFD_COLLECTOR_THREAD_DATA_HANDLE collectorHandle,
                const RFD_MESSAGE_CONFIG_INFO ** defaultMessageConfigInfo);

RFD_STATUS RFD_CollectorIsUpdateFileMetadataMessage(
                const RFD_MESSAGE_CONFIG_INFO * messageConfigInfo,
                UCHAR * messageBuf,
                UINT32 messageSize,
                BOOL * isUpdateFileMetadataMessage);

RFD_STATUS RFD_CollectorParseUpdateFileMetadataMsg(
                const RFD_MESSAGE_CONFIG_INFO * messageConfigInfo,
                UCHAR * messageBuf,
                UINT32 messageSize,
                RFD_FSET_MDATA_STRUCT * fileSetMetadata);

RFD_STATUS RFD_CollectorGetUpdateFileMetadataName(
                RFD_FSET_MDATA_STRUCT * fileSetMetadata,
                TCHAR ** name);

RFD_STATUS RFD_CollectorGetUpdateFileMetadataLife(
                RFD_FSET_MDATA_STRUCT * fileSetMetadata,
                INT32 * life);

RFD_STATUS RFD_CollectorGetUpdateFileMetadataUpdateFilesDmi(
                RFD_FSET_MDATA_STRUCT * fileSetMetadata,
                UINT16 * updateFilesDmi);

RFD_STATUS RFD_CollectorGetClientStateInfo(
                RFD_COLLECTOR_THREAD_DATA_HANDLE collectorHandle,
                RFDR_CLIENT_STATE * clientState,
                RFD_FSET_MDATA_STRUCT * updateFileMetadata);

#ifdef __cplusplus
}
#endif

#endif // RFD_RECEIVER_H