////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_gzio.h
///
/// @brief	Declares the rfd gzio class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RFD_GZIO_H
#define RFD_GZIO_H

#include "rfd_config.h"
#include "zlib.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

// RFD gzio Port

#define GZ_OPEN_MAX_MODE_STRING_LEN 20

ZEXTERN gzFile ZEXPORT rfd_gzopen  OF((const TCHAR *path, const TCHAR *mode));
ZEXTERN void ZEXPORT rfd_gzclearerr OF((gzFile file));
ZEXTERN const char * ZEXPORT rfd_gzerror OF((gzFile file, int *errnum));
ZEXTERN int ZEXPORT    rfd_gzclose OF((gzFile file));
ZEXTERN int ZEXPORT rfd_gzdirect OF((gzFile file));
ZEXTERN int ZEXPORT rfd_gzeof OF((gzFile file));
ZEXTERN z_off_t ZEXPORT    rfd_gztell OF((gzFile file));
ZEXTERN int ZEXPORT    rfd_gzrewind OF((gzFile file));
ZEXTERN z_off_t ZEXPORT    rfd_gzseek OF((gzFile file, z_off_t offset, int whence));
ZEXTERN int ZEXPORT    rfd_gzflush OF((gzFile file, int flush));
ZEXTERN int ZEXPORT    rfd_gzungetc OF((int c, gzFile file));
ZEXTERN int ZEXPORT    rfd_gzgetc OF((gzFile file));
ZEXTERN int ZEXPORT    rfd_gzputc OF((gzFile file, int c));
ZEXTERN char * ZEXPORT rfd_gzgets OF((gzFile file, char *buf, int len));
ZEXTERN int ZEXPORT rfd_gzputs OF((gzFile file, const char *s));
ZEXTERN int ZEXPORTVA   rfd_gzprintf OF((gzFile file, const char *format, ...));
ZEXTERN int ZEXPORT    rfd_gzwrite OF((gzFile file, voidpc buf, unsigned len));
ZEXTERN int ZEXPORT    rfd_gzread  OF((gzFile file, voidp buf, unsigned len));
ZEXTERN int ZEXPORT rfd_gzsetparams OF((gzFile file, int level, int strategy));
ZEXTERN gzFile ZEXPORT rfd_gzdopen  OF((int fd, const char *mode));

#ifdef __cplusplus
}
#endif

#endif // RFD_H
