////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_codec_utils_simple.c
///
/// @brief	rfd codec utils for simple-code class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#include "rfd_codec_simple.h"
//#include "rfd_receiver.h"

///////////////////////////////////////////////////////////////////////////////////////////////
#ifndef BITS_PER_ELEMENT
	#define BITS_PER_ELEMENT 1
	#define RFD_CONSTRUCT_SRC_TYPE_COEFF_ROW   RFD_ConstructSrcTypeCoeffRowSimpleCode
	#define RFD_CONSTRUCT_CHK_TYPE_COEFF_ROW   RFD_ConstructChkTypeCoeffRowSimpleCode
#endif

// ECC_IDENTITY_ELEM_DWORD_ALIGNED
//   e.g. for gf(2) = 0x80000000
//   e.g. for gf(4) = 0x40000000
#define ECC_IDENTITY_ELEM_DWORD_ALIGNED (((DWORD) 1) << (RFD_BITS_PER_DWORD - BITS_PER_ELEMENT))

///////////////////////////////////////////////////////////////////////////////
void RFD_CONSTRUCT_SRC_TYPE_COEFF_ROW(DWORD * coeffRow, UINT16 index, UINT16 coeffRowLenDWords)
{
	int blkIndexDWordOffset;
	int blkIndexBitOffset;

	// clear the coeff row
	RFD_MEMSET( coeffRow, 0, coeffRowLenDWords * sizeof(DWORD));

	blkIndexDWordOffset = (index * BITS_PER_ELEMENT) / RFD_BITS_PER_DWORD;
	blkIndexBitOffset =   (index * BITS_PER_ELEMENT) % RFD_BITS_PER_DWORD;

	if(blkIndexDWordOffset < coeffRowLenDWords) {
		// Note, this clears all other elements in this DWORD to zero.
		coeffRow[blkIndexDWordOffset] = ECC_IDENTITY_ELEM_DWORD_ALIGNED >> blkIndexBitOffset;
	}
	// else unexpected error (bad index parameter passed in).
	// The caller is responsible for this type of error
	// (probably should even do this error check here).

	return;
}

///////////////////////////////////////////////////////////////////////////////
void RFD_CONSTRUCT_CHK_TYPE_COEFF_ROW(DWORD * coeffRow, RFD_XCC_ENC_BLK_INDEX index, UINT16 nCoeffs)
{
	UCHAR * pDst;
	UINT16 i, nBytes, nDWords;

	nBytes = ((nCoeffs * BITS_PER_ELEMENT) / RFD_BITS_PER_BYTE) +
		     (((nCoeffs * BITS_PER_ELEMENT) % RFD_BITS_PER_BYTE) ? 1:0);

	nDWords = (nBytes / sizeof(DWORD)) +
		      ((nBytes % sizeof(DWORD)) ? 1:0);

	// Clear the last coeff row DWord incase row length in bytes
	// is not a multiple of DWords (just so the remaining unused bytes
	// have consistent content)
	coeffRow[nDWords-1] = 0;

	// Initialize pointers to destination and src (lookup table).
	pDst = (UCHAR *) coeffRow;

	// LUT start element is byte aligned,
	// do simpler/faster copy without bit shifting.
	for(i=0;i<nBytes;i++) {
		*pDst++ = 0xff;
	}

	return;
}



