////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_bitstream_io.h
///
/// @brief	Declares the rfd bitstream i/o class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RFD_BITRSTREAM_IO_H
#define RFD_BITRSTREAM_IO_H

#include "rfd_config.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum {
	RFD_BSTRM_SEEK_OS_BEGINING,
	RFD_BSTRM_SEEK_OS_END,
	RFD_BSTRM_SEEK_OS_CURRENT,
	RFD_BSTRM_SEEK_OS_NEXT_BYTE_ALIGN

} RFD_BITSTREAM_SEEK_OFFSET_TYPE;

typedef struct {
	INT32 currByteOffset;
	int   currBitOffset; // bit offset from the nearest Byte boundary.
	UCHAR * streamBuf;
	INT32 streamBitLen;
} RFD_BITSTREAM_INFO;

///////////////////////////////////////////////////////////////////////////////////////////////
int RFD_BitstreamInit(RFD_BITSTREAM_INFO * streamInfo, UCHAR streamBuf[], INT32 streamBitLen);
int RFD_BitstreamPutByteArray(RFD_BITSTREAM_INFO * streamInfo, int nBytes, UCHAR byteBuf[]);
int RFD_BitstreamGetByteArray(RFD_BITSTREAM_INFO * streamInfo, int nBytes, UCHAR byteBuf[]);
int RFD_BitstreamPutU32(RFD_BITSTREAM_INFO * streamInfo, int bitLen, UINT32 dWord);
int RFD_BitstreamGetU32(RFD_BITSTREAM_INFO * streamInfo, int nBits, UINT32 * dWord);
int RFD_BitstreamPeakU32(RFD_BITSTREAM_INFO * streamInfo, int nBits, UINT32 * dWord);
INT32 RFD_BitstreamGetCurrBitPosition(RFD_BITSTREAM_INFO * streamInfo);
int RFD_BitstreamSeek(RFD_BITSTREAM_INFO * streamInfo, INT32 nBits, RFD_BITSTREAM_SEEK_OFFSET_TYPE seekType);
INT32 RFD_BitstreamGetStreamLengthBits(RFD_BITSTREAM_INFO * streamInfo);

#ifdef __cplusplus
}
#endif

#endif // RFD_H