////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_baudot.h
///
/// @brief	Declares the rfd baudot class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RFD_BAUDOT_H
#define RFD_BAUDOT_H

#include "rfd_config.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

///////////////////////////////////////////////////////////////////////////////////////////////

// RFD_BAUDOT_TEST_ENABLE :
// Define this to compile baudot test code
// (then need to call  RFD_BaudotTest()to run the test).
//#define RFD_BAUDOT_TEST_ENABLE

#define RFD_BAUDOT_CONTROL_CODE (TCHAR) 0
#define RFD_BAUDOT_UNUSED_CODE  (TCHAR) 0

#define RFD_BAUDOT_CODE_END     0x00
#define RFD_BAUDOT_CODE_UC_LC   0x02
#define RFD_BAUDOT_CODE_FIG_LTR 0x1f
#define RFD_BAUDOT_CODE_ESC     0x1b
#define RFD_BAUDOT_CODE_CR      0x08

#define RFD_BAUDOT_NUM_ROWS 32

typedef enum {
	BAUDOT_COL_NUM_LTR_UC = 0,
	BAUDOT_COL_NUM_LTR_LC,
	BAUDOT_COL_NUM_FIG,
	BAUDOT_NUM_COLUMNS  // 3
} BAUDOT_COL_NUM_ENUM;

#define NUM_VALID_ROWS_FOR_BAUDOT_COL_LTR_UC  0x20
#define NUM_VALID_ROWS_FOR_BAUDOT_COL_LTR_LC  0x20
#define NUM_VALID_ROWS_FOR_BAUDOT_COL_LTR_FIG 0x20

#define NUM_VALID_ROWS_FOR_BAUDOT_COL_UC_ESC  0x20
#define NUM_VALID_ROWS_FOR_BAUDOT_COL_LC_ESC  0x20
#define NUM_VALID_ROWS_FOR_BAUDOT_COL_FIG_ESC 0x12

extern const TCHAR * baudotColumnEscape[BAUDOT_NUM_COLUMNS];
extern const TCHAR * baudotColumnNonEscape[BAUDOT_NUM_COLUMNS];
extern const unsigned int numValidRowsForBaudotColumnEscape[BAUDOT_NUM_COLUMNS];
extern const unsigned int numValidRowsForBaudotColumnNonEscape[BAUDOT_NUM_COLUMNS];
extern const TCHAR testTableCp1252[256]; // for test


#if defined(RFD_BAUDOT_CONVERSION_CP1252)

// cp1252 - (Windows Code Page 1252) - (Windows-1252)
#define CHAR_NULL									(TCHAR) 0x00	// Unicode 0x0000	//
#define START_OF_HEADING							(TCHAR) 0x01	// Unicode 0x0001	//
#define START_OF_TEXT								(TCHAR) 0x02	// Unicode 0x0002	//
#define END_OF_TEXT									(TCHAR) 0x03	// Unicode 0x0003	//
#define END_OF_TRANSMISSION							(TCHAR) 0x04	// Unicode 0x0004	//
#define ENQUIRY										(TCHAR) 0x05	// Unicode 0x0005	//
#define ACKNOWLEDGE									(TCHAR) 0x06	// Unicode 0x0006	//
#define BELL										(TCHAR) 0x07	// Unicode 0x0007	//
#define BACKSPACE									(TCHAR) 0x08	// Unicode 0x0008	//
#define HORIZONTAL_TABULATION						(TCHAR) 0x09	// Unicode 0x0009	//
#define LINE_FEED									(TCHAR) 0x0A	// Unicode 0x000A	//
#define VERTICAL_TABULATION							(TCHAR) 0x0B	// Unicode 0x000B	//
#define FORM_FEED									(TCHAR) 0x0C	// Unicode 0x000C	//
#define CARRIAGE_RETURN								(TCHAR) 0x0D	// Unicode 0x000D	//
#define SHIFT_OUT									(TCHAR) 0x0E	// Unicode 0x000E	//
#define SHIFT_IN									(TCHAR) 0x0F	// Unicode 0x000F	//
#define DATA_LINK_ESCAPE							(TCHAR) 0x10	// Unicode 0x0010	//
#define DEVICE_CONTROL_ONE							(TCHAR) 0x11	// Unicode 0x0011	//
#define DEVICE_CONTROL_TWO							(TCHAR) 0x12	// Unicode 0x0012	//
#define DEVICE_CONTROL_THREE						(TCHAR) 0x13	// Unicode 0x0013	//
#define DEVICE_CONTROL_FOUR							(TCHAR) 0x14	// Unicode 0x0014	//
#define NEGATIVE_ACKNOWLEDGE						(TCHAR) 0x15	// Unicode 0x0015	//
#define SYNCHRONOUS_IDLE							(TCHAR) 0x16	// Unicode 0x0016	//
#define END_OF_TRANSMISSION_BLOCK					(TCHAR) 0x17	// Unicode 0x0017	//
#define CANCEL										(TCHAR) 0x18	// Unicode 0x0018	//
#define END_OF_MEDIUM								(TCHAR) 0x19	// Unicode 0x0019	//
#define SUBSTITUTE									(TCHAR) 0x1A	// Unicode 0x001A	//
#define ESCAPE										(TCHAR) 0x1B	// Unicode 0x001B	//
#define FILE_SEPARATOR								(TCHAR) 0x1C	// Unicode 0x001C	//
#define GROUP_SEPARATOR								(TCHAR) 0x1D	// Unicode 0x001D	//
#define RECORD_SEPARATOR							(TCHAR) 0x1E	// Unicode 0x001E	//
#define UNIT_SEPARATOR								(TCHAR) 0x1F	// Unicode 0x001F	//
#define SPACE										(TCHAR) 0x20	// Unicode 0x0020	//
#define EXCLAMATION_MARK							(TCHAR) 0x21	// Unicode 0x0021	//  !
#define QUOTATION_MARK								(TCHAR) 0x22	// Unicode 0x0022	//  "
#define NUMBER_SIGN									(TCHAR) 0x23	// Unicode 0x0023	//  #
#define DOLLAR_SIGN									(TCHAR) 0x24	// Unicode 0x0024	//  $
#define PERCENT_SIGN								(TCHAR) 0x25	// Unicode 0x0025	//  %
#define AMPERSAND									(TCHAR) 0x26	// Unicode 0x0026	//  &
#define APOSTROPHE									(TCHAR) 0x27	// Unicode 0x0027	//  '
#define LEFT_PARENTHESIS							(TCHAR) 0x28	// Unicode 0x0028	//  (
#define RIGHT_PARENTHESIS							(TCHAR) 0x29	// Unicode 0x0029	//  )
#define ASTERISK									(TCHAR) 0x2A	// Unicode 0x002A	//  *
#define PLUS_SIGN									(TCHAR) 0x2B	// Unicode 0x002B	//  +
#define COMMA										(TCHAR) 0x2C	// Unicode 0x002C	//  ,
#define HYPHEN_MINUS								(TCHAR) 0x2D	// Unicode 0x002D	//  -
#define FULL_STOP									(TCHAR) 0x2E	// Unicode 0x002E	//  .
#define SOLIDUS										(TCHAR) 0x2F	// Unicode 0x002F	//  /
#define DIGIT_ZERO									(TCHAR) 0x30	// Unicode 0x0030	//  0
#define DIGIT_ONE									(TCHAR) 0x31	// Unicode 0x0031	//  1
#define DIGIT_TWO									(TCHAR) 0x32	// Unicode 0x0032	//  2
#define DIGIT_THREE									(TCHAR) 0x33	// Unicode 0x0033	//  3
#define DIGIT_FOUR									(TCHAR) 0x34	// Unicode 0x0034	//  4
#define DIGIT_FIVE									(TCHAR) 0x35	// Unicode 0x0035	//  5
#define DIGIT_SIX									(TCHAR) 0x36	// Unicode 0x0036	//  6
#define DIGIT_SEVEN									(TCHAR) 0x37	// Unicode 0x0037	//  7
#define DIGIT_EIGHT									(TCHAR) 0x38	// Unicode 0x0038	//  8
#define DIGIT_NINE									(TCHAR) 0x39	// Unicode 0x0039	//  9
#define COLON										(TCHAR) 0x3A	// Unicode 0x003A	//  :
#define SEMICOLON									(TCHAR) 0x3B	// Unicode 0x003B	//  ;
#define LESS_THAN_SIGN								(TCHAR) 0x3C	// Unicode 0x003C	//  <
#define EQUALS_SIGN									(TCHAR) 0x3D	// Unicode 0x003D	//  =
#define GREATER_THAN_SIGN							(TCHAR) 0x3E	// Unicode 0x003E	//  >
#define QUESTION_MARK								(TCHAR) 0x3F	// Unicode 0x003F	//  ?
#define COMMERCIAL_AT								(TCHAR) 0x40	// Unicode 0x0040	//  @
#define LATIN_CAPITAL_LETTER_A						(TCHAR) 0x41	// Unicode 0x0041	//  A
#define LATIN_CAPITAL_LETTER_B						(TCHAR) 0x42	// Unicode 0x0042	//  B
#define LATIN_CAPITAL_LETTER_C						(TCHAR) 0x43	// Unicode 0x0043	//  C
#define LATIN_CAPITAL_LETTER_D						(TCHAR) 0x44	// Unicode 0x0044	//  D
#define LATIN_CAPITAL_LETTER_E						(TCHAR) 0x45	// Unicode 0x0045	//  E
#define LATIN_CAPITAL_LETTER_F						(TCHAR) 0x46	// Unicode 0x0046	//  F
#define LATIN_CAPITAL_LETTER_G						(TCHAR) 0x47	// Unicode 0x0047	//  G
#define LATIN_CAPITAL_LETTER_H						(TCHAR) 0x48	// Unicode 0x0048	//  H
#define LATIN_CAPITAL_LETTER_I						(TCHAR) 0x49	// Unicode 0x0049	//  I
#define LATIN_CAPITAL_LETTER_J						(TCHAR) 0x4A	// Unicode 0x004A	//  J
#define LATIN_CAPITAL_LETTER_K						(TCHAR) 0x4B	// Unicode 0x004B	//  K
#define LATIN_CAPITAL_LETTER_L						(TCHAR) 0x4C	// Unicode 0x004C	//  L
#define LATIN_CAPITAL_LETTER_M						(TCHAR) 0x4D	// Unicode 0x004D	//  M
#define LATIN_CAPITAL_LETTER_N						(TCHAR) 0x4E	// Unicode 0x004E	//  N
#define LATIN_CAPITAL_LETTER_O						(TCHAR) 0x4F	// Unicode 0x004F	//  O
#define LATIN_CAPITAL_LETTER_P						(TCHAR) 0x50	// Unicode 0x0050	//  P
#define LATIN_CAPITAL_LETTER_Q						(TCHAR) 0x51	// Unicode 0x0051	//  Q
#define LATIN_CAPITAL_LETTER_R						(TCHAR) 0x52	// Unicode 0x0052	//  R
#define LATIN_CAPITAL_LETTER_S						(TCHAR) 0x53	// Unicode 0x0053	//  S
#define LATIN_CAPITAL_LETTER_T						(TCHAR) 0x54	// Unicode 0x0054	//  T
#define LATIN_CAPITAL_LETTER_U						(TCHAR) 0x55	// Unicode 0x0055	//  U
#define LATIN_CAPITAL_LETTER_V						(TCHAR) 0x56	// Unicode 0x0056	//  V
#define LATIN_CAPITAL_LETTER_W						(TCHAR) 0x57	// Unicode 0x0057	//  W
#define LATIN_CAPITAL_LETTER_X						(TCHAR) 0x58	// Unicode 0x0058	//  X
#define LATIN_CAPITAL_LETTER_Y						(TCHAR) 0x59	// Unicode 0x0059	//  Y
#define LATIN_CAPITAL_LETTER_Z						(TCHAR) 0x5A	// Unicode 0x005A	//  Z
#define LEFT_SQUARE_BRACKET							(TCHAR) 0x5B	// Unicode 0x005B	//  [
#define REVERSE_SOLIDUS								(TCHAR) 0x5C	/* Unicode 0x005C	    \ */
#define RIGHT_SQUARE_BRACKET						(TCHAR) 0x5D	// Unicode 0x005D	//  ]
#define CIRCUMFLEX_ACCENT							(TCHAR) 0x5E	// Unicode 0x005E	//  ^
#define LOW_LINE									(TCHAR) 0x5F	// Unicode 0x005F	//  _
#define GRAVE_ACCENT								(TCHAR) 0x60	// Unicode 0x0060	//  `
#define LATIN_SMALL_LETTER_A						(TCHAR) 0x61	// Unicode 0x0061	//  a
#define LATIN_SMALL_LETTER_B						(TCHAR) 0x62	// Unicode 0x0062	//  b
#define LATIN_SMALL_LETTER_C						(TCHAR) 0x63	// Unicode 0x0063	//  c
#define LATIN_SMALL_LETTER_D						(TCHAR) 0x64	// Unicode 0x0064	//  d
#define LATIN_SMALL_LETTER_E						(TCHAR) 0x65	// Unicode 0x0065	//  e
#define LATIN_SMALL_LETTER_F						(TCHAR) 0x66	// Unicode 0x0066	//  f
#define LATIN_SMALL_LETTER_G						(TCHAR) 0x67	// Unicode 0x0067	//  g
#define LATIN_SMALL_LETTER_H						(TCHAR) 0x68	// Unicode 0x0068	//  h
#define LATIN_SMALL_LETTER_I						(TCHAR) 0x69	// Unicode 0x0069	//  i
#define LATIN_SMALL_LETTER_J						(TCHAR) 0x6A	// Unicode 0x006A	//  j
#define LATIN_SMALL_LETTER_K						(TCHAR) 0x6B	// Unicode 0x006B	//  k
#define LATIN_SMALL_LETTER_L						(TCHAR) 0x6C	// Unicode 0x006C	//  l
#define LATIN_SMALL_LETTER_M						(TCHAR) 0x6D	// Unicode 0x006D	//  m
#define LATIN_SMALL_LETTER_N						(TCHAR) 0x6E	// Unicode 0x006E	//  n
#define LATIN_SMALL_LETTER_O						(TCHAR) 0x6F	// Unicode 0x006F	//  o
#define LATIN_SMALL_LETTER_P						(TCHAR) 0x70	// Unicode 0x0070	//  p
#define LATIN_SMALL_LETTER_Q						(TCHAR) 0x71	// Unicode 0x0071	//  q
#define LATIN_SMALL_LETTER_R						(TCHAR) 0x72	// Unicode 0x0072	//  r
#define LATIN_SMALL_LETTER_S						(TCHAR) 0x73	// Unicode 0x0073	//  s
#define LATIN_SMALL_LETTER_T						(TCHAR) 0x74	// Unicode 0x0074	//  t
#define LATIN_SMALL_LETTER_U						(TCHAR) 0x75	// Unicode 0x0075	//  u
#define LATIN_SMALL_LETTER_V						(TCHAR) 0x76	// Unicode 0x0076	//  v
#define LATIN_SMALL_LETTER_W						(TCHAR) 0x77	// Unicode 0x0077	//  w
#define LATIN_SMALL_LETTER_X						(TCHAR) 0x78	// Unicode 0x0078	//  x
#define LATIN_SMALL_LETTER_Y						(TCHAR) 0x79	// Unicode 0x0079	//  y
#define LATIN_SMALL_LETTER_Z						(TCHAR) 0x7A	// Unicode 0x007A	//  z
#define LEFT_CURLY_BRACKET							(TCHAR) 0x7B	// Unicode 0x007B	//  {
#define VERTICAL_LINE								(TCHAR) 0x7C	// Unicode 0x007C	//  |
#define RIGHT_CURLY_BRACKET							(TCHAR) 0x7D	// Unicode 0x007D	//  }
#define TILDE										(TCHAR) 0x7E	// Unicode 0x007E	//  ~
#define CHAR_DELETE									(TCHAR) 0x7F	// Unicode 0x007F	//  
#define EURO_SIGN									(TCHAR) 0x80	// Unicode 0x20AC	//  
//#define UNDEFINED									(TCHAR) 0x81
#define SINGLE_LOW_9_QUOTATION_MARK					(TCHAR) 0x82	// Unicode 0x201A	//  
#define LATIN_SMALL_LETTER_F_WITH_HOOK				(TCHAR) 0x83	// Unicode 0x0192	//  
#define DOUBLE_LOW_9_QUOTATION_MARK					(TCHAR) 0x84	// Unicode 0x201E	//  
#define HORIZONTAL_ELLIPSIS							(TCHAR) 0x85	// Unicode 0x2026	//  
#define DAGGER										(TCHAR) 0x86	// Unicode 0x2020	//  
#define DOUBLE_DAGGER								(TCHAR) 0x87	// Unicode 0x2021	//  
#define MODIFIER_LETTER_CIRCUMFLEX_ACCENT			(TCHAR) 0x88	// Unicode 0x02C6	//  
#define PER_MILLE_SIGN								(TCHAR) 0x89	// Unicode 0x2030	//  
#define LATIN_CAPITAL_LETTER_S_WITH_CARON			(TCHAR) 0x8A	// Unicode 0x0160	//  
#define SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK	(TCHAR) 0x8B	// Unicode 0x2039	//  
#define LATIN_CAPITAL_LIGATURE_OE					(TCHAR) 0x8C	// Unicode 0x0152	//  
//#define UNDEFINED									(TCHAR) 0x8D
#define LATIN_CAPITAL_LETTER_Z_WITH_CARON			(TCHAR) 0x8E	// Unicode 0x017D	//  
//#define UNDEFINED									(TCHAR) 0x8F
//#define UNDEFINED									(TCHAR) 0x90
#define LEFT_SINGLE_QUOTATION_MARK					(TCHAR) 0x91	// Unicode 0x2018	//  
#define RIGHT_SINGLE_QUOTATION_MARK					(TCHAR) 0x92	// Unicode 0x2019	//  
#define LEFT_DOUBLE_QUOTATION_MARK					(TCHAR) 0x93	// Unicode 0x201C	//  
#define RIGHT_DOUBLE_QUOTATION_MARK					(TCHAR) 0x94	// Unicode 0x201D	//  
#define BULLET										(TCHAR) 0x95	// Unicode 0x2022	//  
#define EN_DASH										(TCHAR) 0x96	// Unicode 0x2013	//  
#define EM_DASH										(TCHAR) 0x97	// Unicode 0x2014	//  
#define SMALL_TILDE									(TCHAR) 0x98	// Unicode 0x02DC	//  
#define TRADE_MARK_SIGN								(TCHAR) 0x99	// Unicode 0x2122	//  
#define LATIN_SMALL_LETTER_S_WITH_CARON				(TCHAR) 0x9A	// Unicode 0x0161	//  
#define SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK	(TCHAR) 0x9B	// Unicode 0x203A	//  
#define LATIN_SMALL_LIGATURE_OE						(TCHAR) 0x9C	// Unicode 0x0153	//  
//#define UNDEFINED									(TCHAR) 0x9D
#define LATIN_SMALL_LETTER_Z_WITH_CARON				(TCHAR) 0x9E	// Unicode 0x017E	//  
#define LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS		(TCHAR) 0x9F	// Unicode 0x0178	//  
#define NO_BREAK_SPACE								(TCHAR) 0xA0	// Unicode 0x00A0	//  
#define INVERTED_EXCLAMATION_MARK					(TCHAR) 0xA1	// Unicode 0x00A1	//  
#define CENT_SIGN									(TCHAR) 0xA2	// Unicode 0x00A2	//  
#define POUND_SIGN									(TCHAR) 0xA3	// Unicode 0x00A3	//  
#define CURRENCY_SIGN								(TCHAR) 0xA4	// Unicode 0x00A4	//  
#define YEN_SIGN									(TCHAR) 0xA5	// Unicode 0x00A5	//  
#define BROKEN_BAR									(TCHAR) 0xA6	// Unicode 0x00A6	//  
#define SECTION_SIGN								(TCHAR) 0xA7	// Unicode 0x00A7	//  
#define DIAERESIS									(TCHAR) 0xA8	// Unicode 0x00A8	//  
#define COPYRIGHT_SIGN								(TCHAR) 0xA9	// Unicode 0x00A9	//  
#define FEMININE_ORDINAL_INDICATOR					(TCHAR) 0xAA	// Unicode 0x00AA	//  
#define LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	(TCHAR) 0xAB	// Unicode 0x00AB	//  
#define NOT_SIGN									(TCHAR) 0xAC	// Unicode 0x00AC	//  
#define SOFT_HYPHEN									(TCHAR) 0xAD	// Unicode 0x00AD	//  
#define REGISTERED_SIGN								(TCHAR) 0xAE	// Unicode 0x00AE	//  
#define MACRON										(TCHAR) 0xAF	// Unicode 0x00AF	//  
#define DEGREE_SIGN									(TCHAR) 0xB0	// Unicode 0x00B0	//  
#define PLUS_MINUS_SIGN								(TCHAR) 0xB1	// Unicode 0x00B1	//  
#define SUPERSCRIPT_TWO								(TCHAR) 0xB2	// Unicode 0x00B2	//  
#define SUPERSCRIPT_THREE							(TCHAR) 0xB3	// Unicode 0x00B3	//  
#define ACUTE_ACCENT								(TCHAR) 0xB4	// Unicode 0x00B4	//  
#define MICRO_SIGN									(TCHAR) 0xB5	// Unicode 0x00B5	//  
#define PILCROW_SIGN								(TCHAR) 0xB6	// Unicode 0x00B6	//  
#define MIDDLE_DOT									(TCHAR) 0xB7	// Unicode 0x00B7	//  
#define CEDILLA										(TCHAR) 0xB8	// Unicode 0x00B8	//  
#define SUPERSCRIPT_ONE								(TCHAR) 0xB9	// Unicode 0x00B9	//  
#define MASCULINE_ORDINAL_INDICATOR					(TCHAR) 0xBA	// Unicode 0x00BA	//  
#define RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	(TCHAR) 0xBB	// Unicode 0x00BB	//  
#define VULGAR_FRACTION_ONE_QUARTER					(TCHAR) 0xBC	// Unicode 0x00BC	//  
#define VULGAR_FRACTION_ONE_HALF					(TCHAR) 0xBD	// Unicode 0x00BD	//  
#define VULGAR_FRACTION_THREE_QUARTERS				(TCHAR) 0xBE	// Unicode 0x00BE	//  
#define INVERTED_QUESTION_MARK						(TCHAR) 0xBF	// Unicode 0x00BF	//  
#define LATIN_CAPITAL_LETTER_A_WITH_GRAVE			(TCHAR) 0xC0	// Unicode 0x00C0	//  
#define LATIN_CAPITAL_LETTER_A_WITH_ACUTE			(TCHAR) 0xC1	// Unicode 0x00C1	//  
#define LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX		(TCHAR) 0xC2	// Unicode 0x00C2	//  
#define LATIN_CAPITAL_LETTER_A_WITH_TILDE			(TCHAR) 0xC3	// Unicode 0x00C3	//  
#define LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS		(TCHAR) 0xC4	// Unicode 0x00C4	//  
#define LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE		(TCHAR) 0xC5	// Unicode 0x00C5	//  
#define LATIN_CAPITAL_LETTER_AE						(TCHAR) 0xC6	// Unicode 0x00C6	//  
#define LATIN_CAPITAL_LETTER_C_WITH_CEDILLA			(TCHAR) 0xC7	// Unicode 0x00C7	//  
#define LATIN_CAPITAL_LETTER_E_WITH_GRAVE			(TCHAR) 0xC8	// Unicode 0x00C8	//  
#define LATIN_CAPITAL_LETTER_E_WITH_ACUTE			(TCHAR) 0xC9	// Unicode 0x00C9	//  
#define LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX		(TCHAR) 0xCA	// Unicode 0x00CA	//  
#define LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS		(TCHAR) 0xCB	// Unicode 0x00CB	//  
#define LATIN_CAPITAL_LETTER_I_WITH_GRAVE			(TCHAR) 0xCC	// Unicode 0x00CC	//  
#define LATIN_CAPITAL_LETTER_I_WITH_ACUTE			(TCHAR) 0xCD	// Unicode 0x00CD	//  
#define LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX		(TCHAR) 0xCE	// Unicode 0x00CE	//  
#define LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS		(TCHAR) 0xCF	// Unicode 0x00CF	//  
#define LATIN_CAPITAL_LETTER_ETH					(TCHAR) 0xD0	// Unicode 0x00D0	//  
#define LATIN_CAPITAL_LETTER_N_WITH_TILDE			(TCHAR) 0xD1	// Unicode 0x00D1	//  
#define LATIN_CAPITAL_LETTER_O_WITH_GRAVE			(TCHAR) 0xD2	// Unicode 0x00D2	//  
#define LATIN_CAPITAL_LETTER_O_WITH_ACUTE			(TCHAR) 0xD3	// Unicode 0x00D3	//  
#define LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX		(TCHAR) 0xD4	// Unicode 0x00D4	//  
#define LATIN_CAPITAL_LETTER_O_WITH_TILDE			(TCHAR) 0xD5	// Unicode 0x00D5	//  
#define LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS		(TCHAR) 0xD6	// Unicode 0x00D6	//  
#define MULTIPLICATION_SIGN							(TCHAR) 0xD7	// Unicode 0x00D7	//  
#define LATIN_CAPITAL_LETTER_O_WITH_STROKE			(TCHAR) 0xD8	// Unicode 0x00D8	//  
#define LATIN_CAPITAL_LETTER_U_WITH_GRAVE			(TCHAR) 0xD9	// Unicode 0x00D9	//  
#define LATIN_CAPITAL_LETTER_U_WITH_ACUTE			(TCHAR) 0xDA	// Unicode 0x00DA	//  
#define LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX		(TCHAR) 0xDB	// Unicode 0x00DB	//  
#define LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS		(TCHAR) 0xDC	// Unicode 0x00DC	//  
#define LATIN_CAPITAL_LETTER_Y_WITH_ACUTE			(TCHAR) 0xDD	// Unicode 0x00DD	//  
#define LATIN_CAPITAL_LETTER_THORN					(TCHAR) 0xDE	// Unicode 0x00DE	//  
#define LATIN_SMALL_LETTER_SHARP_S					(TCHAR) 0xDF	// Unicode 0x00DF	//  
#define LATIN_SMALL_LETTER_A_WITH_GRAVE				(TCHAR) 0xE0	// Unicode 0x00E0	//  
#define LATIN_SMALL_LETTER_A_WITH_ACUTE				(TCHAR) 0xE1	// Unicode 0x00E1	//  
#define LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX		(TCHAR) 0xE2	// Unicode 0x00E2	//  
#define LATIN_SMALL_LETTER_A_WITH_TILDE				(TCHAR) 0xE3	// Unicode 0x00E3	//  
#define LATIN_SMALL_LETTER_A_WITH_DIAERESIS			(TCHAR) 0xE4	// Unicode 0x00E4	//  
#define LATIN_SMALL_LETTER_A_WITH_RING_ABOVE		(TCHAR) 0xE5	// Unicode 0x00E5	//  
#define LATIN_SMALL_LETTER_AE						(TCHAR) 0xE6	// Unicode 0x00E6	//  
#define LATIN_SMALL_LETTER_C_WITH_CEDILLA			(TCHAR) 0xE7	// Unicode 0x00E7	//  
#define LATIN_SMALL_LETTER_E_WITH_GRAVE				(TCHAR) 0xE8	// Unicode 0x00E8	//  
#define LATIN_SMALL_LETTER_E_WITH_ACUTE				(TCHAR) 0xE9	// Unicode 0x00E9	//  
#define LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX		(TCHAR) 0xEA	// Unicode 0x00EA	//  
#define LATIN_SMALL_LETTER_E_WITH_DIAERESIS			(TCHAR) 0xEB	// Unicode 0x00EB	//  
#define LATIN_SMALL_LETTER_I_WITH_GRAVE				(TCHAR) 0xEC	// Unicode 0x00EC	//  
#define LATIN_SMALL_LETTER_I_WITH_ACUTE				(TCHAR) 0xED	// Unicode 0x00ED	//  
#define LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX		(TCHAR) 0xEE	// Unicode 0x00EE	//  
#define LATIN_SMALL_LETTER_I_WITH_DIAERESIS			(TCHAR) 0xEF	// Unicode 0x00EF	//  
#define LATIN_SMALL_LETTER_ETH						(TCHAR) 0xF0	// Unicode 0x00F0	//  
#define LATIN_SMALL_LETTER_N_WITH_TILDE				(TCHAR) 0xF1	// Unicode 0x00F1	//  
#define LATIN_SMALL_LETTER_O_WITH_GRAVE				(TCHAR) 0xF2	// Unicode 0x00F2	//  
#define LATIN_SMALL_LETTER_O_WITH_ACUTE				(TCHAR) 0xF3	// Unicode 0x00F3	//  
#define LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX		(TCHAR) 0xF4	// Unicode 0x00F4	//  
#define LATIN_SMALL_LETTER_O_WITH_TILDE				(TCHAR) 0xF5	// Unicode 0x00F5	//  
#define LATIN_SMALL_LETTER_O_WITH_DIAERESIS			(TCHAR) 0xF6	// Unicode 0x00F6	//  
#define DIVISION_SIGN								(TCHAR) 0xF7	// Unicode 0x00F7	//  
#define LATIN_SMALL_LETTER_O_WITH_STROKE			(TCHAR) 0xF8	// Unicode 0x00F8	//  
#define LATIN_SMALL_LETTER_U_WITH_GRAVE				(TCHAR) 0xF9	// Unicode 0x00F9	//  
#define LATIN_SMALL_LETTER_U_WITH_ACUTE				(TCHAR) 0xFA	// Unicode 0x00FA	//  
#define LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX		(TCHAR) 0xFB	// Unicode 0x00FB	//  
#define LATIN_SMALL_LETTER_U_WITH_DIAERESIS			(TCHAR) 0xFC	// Unicode 0x00FC	//  
#define LATIN_SMALL_LETTER_Y_WITH_ACUTE				(TCHAR) 0xFD	// Unicode 0x00FD	//  
#define LATIN_SMALL_LETTER_THORN					(TCHAR) 0xFE	// Unicode 0x00FE	//  
#define LATIN_SMALL_LETTER_Y_WITH_DIAERESIS			(TCHAR) 0xFF	// Unicode 0x00FF	//  

#elif defined(RFD_BAUDOT_CONVERSION_ISO_IEC_8859_15)

//_ISO/IEC_8859_15

#define	CHAR_NULL									(TCHAR) 0x00	// Unicode 0x0000
#define	START_OF_HEADING							(TCHAR) 0x01	// Unicode 0x0001
#define	START_OF_TEXT								(TCHAR) 0x02	// Unicode 0x0002
#define	END_OF_TEXT									(TCHAR) 0x03	// Unicode 0x0003
#define	END_OF_TRANSMISSION							(TCHAR) 0x04	// Unicode 0x0004
#define	ENQUIRY										(TCHAR) 0x05	// Unicode 0x0005
#define	ACKNOWLEDGE									(TCHAR) 0x06	// Unicode 0x0006
#define	BELL										(TCHAR) 0x07	// Unicode 0x0007
#define	BACKSPACE									(TCHAR) 0x08	// Unicode 0x0008
#define	HORIZONTAL_TABULATION						(TCHAR) 0x09	// Unicode 0x0009
#define	LINE_FEED									(TCHAR) 0x0A	// Unicode 0x000A
#define	VERTICAL_TABULATION							(TCHAR) 0x0B	// Unicode 0x000B
#define	FORM_FEED									(TCHAR) 0x0C	// Unicode 0x000C
#define	CARRIAGE_RETURN								(TCHAR) 0x0D	// Unicode 0x000D
#define	SHIFT_OUT									(TCHAR) 0x0E	// Unicode 0x000E
#define	SHIFT_IN									(TCHAR) 0x0F	// Unicode 0x000F
#define	DATA_LINK_ESCAPE							(TCHAR) 0x10	// Unicode 0x0010
#define	DEVICE_CONTROL_ONE							(TCHAR) 0x11	// Unicode 0x0011
#define	DEVICE_CONTROL_TWO							(TCHAR) 0x12	// Unicode 0x0012
#define	DEVICE_CONTROL_THREE						(TCHAR) 0x13	// Unicode 0x0013
#define	DEVICE_CONTROL_FOUR							(TCHAR) 0x14	// Unicode 0x0014
#define	NEGATIVE_ACKNOWLEDGE						(TCHAR) 0x15	// Unicode 0x0015
#define	SYNCHRONOUS_IDLE							(TCHAR) 0x16	// Unicode 0x0016
#define	END_OF_TRANSMISSION_BLOCK					(TCHAR) 0x17	// Unicode 0x0017
#define	CANCEL										(TCHAR) 0x18	// Unicode 0x0018
#define	END_OF_MEDIUM								(TCHAR) 0x19	// Unicode 0x0019
#define	SUBSTITUTE									(TCHAR) 0x1A	// Unicode 0x001A
#define	ESCAPE										(TCHAR) 0x1B	// Unicode 0x001B
#define	FILE_SEPARATOR								(TCHAR) 0x1C	// Unicode 0x001C
#define	GROUP_SEPARATOR								(TCHAR) 0x1D	// Unicode 0x001D
#define	RECORD_SEPARATOR							(TCHAR) 0x1E	// Unicode 0x001E
#define	UNIT_SEPARATOR								(TCHAR) 0x1F	// Unicode 0x001F
#define	SPACE										(TCHAR) 0x20	// Unicode 0x0020
#define	EXCLAMATION_MARK							(TCHAR) 0x21	// Unicode 0x0021
#define	QUOTATION_MARK								(TCHAR) 0x22	// Unicode 0x0022
#define	NUMBER_SIGN									(TCHAR) 0x23	// Unicode 0x0023
#define	DOLLAR_SIGN									(TCHAR) 0x24	// Unicode 0x0024
#define	PERCENT_SIGN								(TCHAR) 0x25	// Unicode 0x0025
#define	AMPERSAND									(TCHAR) 0x26	// Unicode 0x0026
#define	APOSTROPHE									(TCHAR) 0x27	// Unicode 0x0027
#define	LEFT_PARENTHESIS							(TCHAR) 0x28	// Unicode 0x0028
#define	RIGHT_PARENTHESIS							(TCHAR) 0x29	// Unicode 0x0029
#define	ASTERISK									(TCHAR) 0x2A	// Unicode 0x002A
#define	PLUS_SIGN									(TCHAR) 0x2B	// Unicode 0x002B
#define	COMMA										(TCHAR) 0x2C	// Unicode 0x002C
#define	HYPHEN_MINUS								(TCHAR) 0x2D	// Unicode 0x002D
#define	FULL_STOP									(TCHAR) 0x2E	// Unicode 0x002E
#define	SOLIDUS										(TCHAR) 0x2F	// Unicode 0x002F
#define	DIGIT_ZERO									(TCHAR) 0x30	// Unicode 0x0030
#define	DIGIT_ONE									(TCHAR) 0x31	// Unicode 0x0031
#define	DIGIT_TWO									(TCHAR) 0x32	// Unicode 0x0032
#define	DIGIT_THREE									(TCHAR) 0x33	// Unicode 0x0033
#define	DIGIT_FOUR									(TCHAR) 0x34	// Unicode 0x0034
#define	DIGIT_FIVE									(TCHAR) 0x35	// Unicode 0x0035
#define	DIGIT_SIX									(TCHAR) 0x36	// Unicode 0x0036
#define	DIGIT_SEVEN									(TCHAR) 0x37	// Unicode 0x0037
#define	DIGIT_EIGHT									(TCHAR) 0x38	// Unicode 0x0038
#define	DIGIT_NINE									(TCHAR) 0x39	// Unicode 0x0039
#define	COLON										(TCHAR) 0x3A	// Unicode 0x003A
#define	SEMICOLON									(TCHAR) 0x3B	// Unicode 0x003B
#define	LESS_THAN_SIGN								(TCHAR) 0x3C	// Unicode 0x003C
#define	EQUALS_SIGN									(TCHAR) 0x3D	// Unicode 0x003D
#define	GREATER_THAN_SIGN							(TCHAR) 0x3E	// Unicode 0x003E
#define	QUESTION_MARK								(TCHAR) 0x3F	// Unicode 0x003F
#define	COMMERCIAL_AT								(TCHAR) 0x40	// Unicode 0x0040
#define	LATIN_CAPITAL_LETTER_A						(TCHAR) 0x41	// Unicode 0x0041
#define	LATIN_CAPITAL_LETTER_B						(TCHAR) 0x42	// Unicode 0x0042
#define	LATIN_CAPITAL_LETTER_C						(TCHAR) 0x43	// Unicode 0x0043
#define	LATIN_CAPITAL_LETTER_D						(TCHAR) 0x44	// Unicode 0x0044
#define	LATIN_CAPITAL_LETTER_E						(TCHAR) 0x45	// Unicode 0x0045
#define	LATIN_CAPITAL_LETTER_F						(TCHAR) 0x46	// Unicode 0x0046
#define	LATIN_CAPITAL_LETTER_G						(TCHAR) 0x47	// Unicode 0x0047
#define	LATIN_CAPITAL_LETTER_H						(TCHAR) 0x48	// Unicode 0x0048
#define	LATIN_CAPITAL_LETTER_I						(TCHAR) 0x49	// Unicode 0x0049
#define	LATIN_CAPITAL_LETTER_J						(TCHAR) 0x4A	// Unicode 0x004A
#define	LATIN_CAPITAL_LETTER_K						(TCHAR) 0x4B	// Unicode 0x004B
#define	LATIN_CAPITAL_LETTER_L						(TCHAR) 0x4C	// Unicode 0x004C
#define	LATIN_CAPITAL_LETTER_M						(TCHAR) 0x4D	// Unicode 0x004D
#define	LATIN_CAPITAL_LETTER_N						(TCHAR) 0x4E	// Unicode 0x004E
#define	LATIN_CAPITAL_LETTER_O						(TCHAR) 0x4F	// Unicode 0x004F
#define	LATIN_CAPITAL_LETTER_P						(TCHAR) 0x50	// Unicode 0x0050
#define	LATIN_CAPITAL_LETTER_Q						(TCHAR) 0x51	// Unicode 0x0051
#define	LATIN_CAPITAL_LETTER_R						(TCHAR) 0x52	// Unicode 0x0052
#define	LATIN_CAPITAL_LETTER_S						(TCHAR) 0x53	// Unicode 0x0053
#define	LATIN_CAPITAL_LETTER_T						(TCHAR) 0x54	// Unicode 0x0054
#define	LATIN_CAPITAL_LETTER_U						(TCHAR) 0x55	// Unicode 0x0055
#define	LATIN_CAPITAL_LETTER_V						(TCHAR) 0x56	// Unicode 0x0056
#define	LATIN_CAPITAL_LETTER_W						(TCHAR) 0x57	// Unicode 0x0057
#define	LATIN_CAPITAL_LETTER_X						(TCHAR) 0x58	// Unicode 0x0058
#define	LATIN_CAPITAL_LETTER_Y						(TCHAR) 0x59	// Unicode 0x0059
#define	LATIN_CAPITAL_LETTER_Z						(TCHAR) 0x5A	// Unicode 0x005A
#define	LEFT_SQUARE_BRACKET							(TCHAR) 0x5B	// Unicode 0x005B
#define	REVERSE_SOLIDUS								(TCHAR) 0x5C	// Unicode 0x005C
#define	RIGHT_SQUARE_BRACKET						(TCHAR) 0x5D	// Unicode 0x005D
#define	CIRCUMFLEX_ACCENT							(TCHAR) 0x5E	// Unicode 0x005E
#define	LOW_LINE									(TCHAR) 0x5F	// Unicode 0x005F
#define	GRAVE_ACCENT								(TCHAR) 0x60	// Unicode 0x0060
#define	LATIN_SMALL_LETTER_A						(TCHAR) 0x61	// Unicode 0x0061
#define	LATIN_SMALL_LETTER_B						(TCHAR) 0x62	// Unicode 0x0062
#define	LATIN_SMALL_LETTER_C						(TCHAR) 0x63	// Unicode 0x0063
#define	LATIN_SMALL_LETTER_D						(TCHAR) 0x64	// Unicode 0x0064
#define	LATIN_SMALL_LETTER_E						(TCHAR) 0x65	// Unicode 0x0065
#define	LATIN_SMALL_LETTER_F						(TCHAR) 0x66	// Unicode 0x0066
#define	LATIN_SMALL_LETTER_G						(TCHAR) 0x67	// Unicode 0x0067
#define	LATIN_SMALL_LETTER_H						(TCHAR) 0x68	// Unicode 0x0068
#define	LATIN_SMALL_LETTER_I						(TCHAR) 0x69	// Unicode 0x0069
#define	LATIN_SMALL_LETTER_J						(TCHAR) 0x6A	// Unicode 0x006A
#define	LATIN_SMALL_LETTER_K						(TCHAR) 0x6B	// Unicode 0x006B
#define	LATIN_SMALL_LETTER_L						(TCHAR) 0x6C	// Unicode 0x006C
#define	LATIN_SMALL_LETTER_M						(TCHAR) 0x6D	// Unicode 0x006D
#define	LATIN_SMALL_LETTER_N						(TCHAR) 0x6E	// Unicode 0x006E
#define	LATIN_SMALL_LETTER_O						(TCHAR) 0x6F	// Unicode 0x006F
#define	LATIN_SMALL_LETTER_P						(TCHAR) 0x70	// Unicode 0x0070
#define	LATIN_SMALL_LETTER_Q						(TCHAR) 0x71	// Unicode 0x0071
#define	LATIN_SMALL_LETTER_R						(TCHAR) 0x72	// Unicode 0x0072
#define	LATIN_SMALL_LETTER_S						(TCHAR) 0x73	// Unicode 0x0073
#define	LATIN_SMALL_LETTER_T						(TCHAR) 0x74	// Unicode 0x0074
#define	LATIN_SMALL_LETTER_U						(TCHAR) 0x75	// Unicode 0x0075
#define	LATIN_SMALL_LETTER_V						(TCHAR) 0x76	// Unicode 0x0076
#define	LATIN_SMALL_LETTER_W						(TCHAR) 0x77	// Unicode 0x0077
#define	LATIN_SMALL_LETTER_X						(TCHAR) 0x78	// Unicode 0x0078
#define	LATIN_SMALL_LETTER_Y						(TCHAR) 0x79	// Unicode 0x0079
#define	LATIN_SMALL_LETTER_Z						(TCHAR) 0x7A	// Unicode 0x007A
#define	LEFT_CURLY_BRACKET							(TCHAR) 0x7B	// Unicode 0x007B
#define	VERTICAL_LINE								(TCHAR) 0x7C	// Unicode 0x007C
#define	RIGHT_CURLY_BRACKET							(TCHAR) 0x7D	// Unicode 0x007D
#define	TILDE										(TCHAR) 0x7E	// Unicode 0x007E
#define	CHAR_DELETE									(TCHAR) 0x7F	// Unicode 0x007F
//#define	<control>								(TCHAR) 0x80	// Unicode 0x0080
//#define	<control>								(TCHAR) 0x81	// Unicode 0x0081
//#define	<control>								(TCHAR) 0x82	// Unicode 0x0082
//#define	<control>								(TCHAR) 0x83	// Unicode 0x0083
//#define	<control>								(TCHAR) 0x84	// Unicode 0x0084
//#define	<control>								(TCHAR) 0x85	// Unicode 0x0085
//#define	<control>								(TCHAR) 0x86	// Unicode 0x0086
//#define	<control>								(TCHAR) 0x87	// Unicode 0x0087
//#define	<control>								(TCHAR) 0x88	// Unicode 0x0088
//#define	<control>								(TCHAR) 0x89	// Unicode 0x0089
//#define	<control>								(TCHAR) 0x8A	// Unicode 0x008A
//#define	<control>								(TCHAR) 0x8B	// Unicode 0x008B
//#define	<control>								(TCHAR) 0x8C	// Unicode 0x008C
//#define	<control>								(TCHAR) 0x8D	// Unicode 0x008D
//#define	<control>								(TCHAR) 0x8E	// Unicode 0x008E
//#define	<control>								(TCHAR) 0x8F	// Unicode 0x008F
//#define	<control>								(TCHAR) 0x90	// Unicode 0x0090
//#define	<control>								(TCHAR) 0x91	// Unicode 0x0091
//#define	<control>								(TCHAR) 0x92	// Unicode 0x0092
//#define	<control>								(TCHAR) 0x93	// Unicode 0x0093
//#define	<control>								(TCHAR) 0x94	// Unicode 0x0094
//#define	<control>								(TCHAR) 0x95	// Unicode 0x0095
//#define	<control>								(TCHAR) 0x96	// Unicode 0x0096
//#define	<control>								(TCHAR) 0x97	// Unicode 0x0097
//#define	<control>								(TCHAR) 0x98	// Unicode 0x0098
//#define	<control>								(TCHAR) 0x99	// Unicode 0x0099
//#define	<control>								(TCHAR) 0x9A	// Unicode 0x009A
//#define	<control>								(TCHAR) 0x9B	// Unicode 0x009B
//#define	<control>								(TCHAR) 0x9C	// Unicode 0x009C
//#define	<control>								(TCHAR) 0x9D	// Unicode 0x009D
//#define	<control>								(TCHAR) 0x9E	// Unicode 0x009E
//#define	<control>								(TCHAR) 0x9F	// Unicode 0x009F
#define	NO_BREAK_SPACE								(TCHAR) 0xA0	// Unicode 0x00A0
#define	INVERTED_EXCLAMATION_MARK					(TCHAR) 0xA1	// Unicode 0x00A1
#define	CENT_SIGN									(TCHAR) 0xA2	// Unicode 0x00A2
#define	POUND_SIGN									(TCHAR) 0xA3	// Unicode 0x00A3
#define	EURO_SIGN									(TCHAR) 0xA4	// Unicode 0x20AC
#define	YEN_SIGN									(TCHAR) 0xA5	// Unicode 0x00A5
#define	LATIN_CAPITAL_LETTER_S_WITH_CARON			(TCHAR) 0xA6	// Unicode 0x0160
#define	SECTION_SIGN								(TCHAR) 0xA7	// Unicode 0x00A7
#define	LATIN_SMALL_LETTER_S_WITH_CARON				(TCHAR) 0xA8	// Unicode 0x0161
#define	COPYRIGHT_SIGN								(TCHAR) 0xA9	// Unicode 0x00A9
#define	FEMININE_ORDINAL_INDICATOR					(TCHAR) 0xAA	// Unicode 0x00AA
#define	LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	(TCHAR) 0xAB	// Unicode 0x00AB
#define	NOT_SIGN									(TCHAR) 0xAC	// Unicode 0x00AC
#define	SOFT_HYPHEN									(TCHAR) 0xAD	// Unicode 0x00AD
#define	REGISTERED_SIGN								(TCHAR) 0xAE	// Unicode 0x00AE
#define	MACRON										(TCHAR) 0xAF	// Unicode 0x00AF
#define	DEGREE_SIGN									(TCHAR) 0xB0	// Unicode 0x00B0
#define	PLUS_MINUS_SIGN								(TCHAR) 0xB1	// Unicode 0x00B1
#define	SUPERSCRIPT_TWO								(TCHAR) 0xB2	// Unicode 0x00B2
#define	SUPERSCRIPT_THREE							(TCHAR) 0xB3	// Unicode 0x00B3
#define	LATIN_CAPITAL_LETTER_Z_WITH_CARON			(TCHAR) 0xB4	// Unicode 0x017D
#define	MICRO_SIGN									(TCHAR) 0xB5	// Unicode 0x00B5
#define	PILCROW_SIGN								(TCHAR) 0xB6	// Unicode 0x00B6
#define	MIDDLE_DOT									(TCHAR) 0xB7	// Unicode 0x00B7
#define	LATIN_SMALL_LETTER_Z_WITH_CARON				(TCHAR) 0xB8	// Unicode 0x017E
#define	SUPERSCRIPT_ONE								(TCHAR) 0xB9	// Unicode 0x00B9
#define	MASCULINE_ORDINAL_INDICATOR					(TCHAR) 0xBA	// Unicode 0x00BA
#define	RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	(TCHAR) 0xBB	// Unicode 0x00BB
#define	LATIN_CAPITAL_LIGATURE_OE					(TCHAR) 0xBC	// Unicode 0x0152
#define	LATIN_SMALL_LIGATURE_OE						(TCHAR) 0xBD	// Unicode 0x0153
#define	LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS		(TCHAR) 0xBE	// Unicode 0x0178
#define	INVERTED_QUESTION_MARK						(TCHAR) 0xBF	// Unicode 0x00BF
#define	LATIN_CAPITAL_LETTER_A_WITH_GRAVE			(TCHAR) 0xC0	// Unicode 0x00C0
#define	LATIN_CAPITAL_LETTER_A_WITH_ACUTE			(TCHAR) 0xC1	// Unicode 0x00C1
#define	LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX		(TCHAR) 0xC2	// Unicode 0x00C2
#define	LATIN_CAPITAL_LETTER_A_WITH_TILDE			(TCHAR) 0xC3	// Unicode 0x00C3
#define	LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS		(TCHAR) 0xC4	// Unicode 0x00C4
#define	LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE		(TCHAR) 0xC5	// Unicode 0x00C5
#define	LATIN_CAPITAL_LETTER_AE						(TCHAR) 0xC6	// Unicode 0x00C6
#define	LATIN_CAPITAL_LETTER_C_WITH_CEDILLA			(TCHAR) 0xC7	// Unicode 0x00C7
#define	LATIN_CAPITAL_LETTER_E_WITH_GRAVE			(TCHAR) 0xC8	// Unicode 0x00C8
#define	LATIN_CAPITAL_LETTER_E_WITH_ACUTE			(TCHAR) 0xC9	// Unicode 0x00C9
#define	LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX		(TCHAR) 0xCA	// Unicode 0x00CA
#define	LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS		(TCHAR) 0xCB	// Unicode 0x00CB
#define	LATIN_CAPITAL_LETTER_I_WITH_GRAVE			(TCHAR) 0xCC	// Unicode 0x00CC
#define	LATIN_CAPITAL_LETTER_I_WITH_ACUTE			(TCHAR) 0xCD	// Unicode 0x00CD
#define	LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX		(TCHAR) 0xCE	// Unicode 0x00CE
#define	LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS		(TCHAR) 0xCF	// Unicode 0x00CF
#define	LATIN_CAPITAL_LETTER_ETH					(TCHAR) 0xD0	// Unicode 0x00D0
#define	LATIN_CAPITAL_LETTER_N_WITH_TILDE			(TCHAR) 0xD1	// Unicode 0x00D1
#define	LATIN_CAPITAL_LETTER_O_WITH_GRAVE			(TCHAR) 0xD2	// Unicode 0x00D2
#define	LATIN_CAPITAL_LETTER_O_WITH_ACUTE			(TCHAR) 0xD3	// Unicode 0x00D3
#define	LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX		(TCHAR) 0xD4	// Unicode 0x00D4
#define	LATIN_CAPITAL_LETTER_O_WITH_TILDE			(TCHAR) 0xD5	// Unicode 0x00D5
#define	LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS		(TCHAR) 0xD6	// Unicode 0x00D6
#define	MULTIPLICATION_SIGN							(TCHAR) 0xD7	// Unicode 0x00D7
#define	LATIN_CAPITAL_LETTER_O_WITH_STROKE			(TCHAR) 0xD8	// Unicode 0x00D8
#define	LATIN_CAPITAL_LETTER_U_WITH_GRAVE			(TCHAR) 0xD9	// Unicode 0x00D9
#define	LATIN_CAPITAL_LETTER_U_WITH_ACUTE			(TCHAR) 0xDA	// Unicode 0x00DA
#define	LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX		(TCHAR) 0xDB	// Unicode 0x00DB
#define	LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS		(TCHAR) 0xDC	// Unicode 0x00DC
#define	LATIN_CAPITAL_LETTER_Y_WITH_ACUTE			(TCHAR) 0xDD	// Unicode 0x00DD
#define	LATIN_CAPITAL_LETTER_THORN					(TCHAR) 0xDE	// Unicode 0x00DE
#define	LATIN_SMALL_LETTER_SHARP_S					(TCHAR) 0xDF	// Unicode 0x00DF
#define	LATIN_SMALL_LETTER_A_WITH_GRAVE				(TCHAR) 0xE0	// Unicode 0x00E0
#define	LATIN_SMALL_LETTER_A_WITH_ACUTE				(TCHAR) 0xE1	// Unicode 0x00E1
#define	LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX		(TCHAR) 0xE2	// Unicode 0x00E2
#define	LATIN_SMALL_LETTER_A_WITH_TILDE				(TCHAR) 0xE3	// Unicode 0x00E3
#define	LATIN_SMALL_LETTER_A_WITH_DIAERESIS			(TCHAR) 0xE4	// Unicode 0x00E4
#define	LATIN_SMALL_LETTER_A_WITH_RING_ABOVE		(TCHAR) 0xE5	// Unicode 0x00E5
#define	LATIN_SMALL_LETTER_AE						(TCHAR) 0xE6	// Unicode 0x00E6
#define	LATIN_SMALL_LETTER_C_WITH_CEDILLA			(TCHAR) 0xE7	// Unicode 0x00E7
#define	LATIN_SMALL_LETTER_E_WITH_GRAVE				(TCHAR) 0xE8	// Unicode 0x00E8
#define	LATIN_SMALL_LETTER_E_WITH_ACUTE				(TCHAR) 0xE9	// Unicode 0x00E9
#define	LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX		(TCHAR) 0xEA	// Unicode 0x00EA
#define	LATIN_SMALL_LETTER_E_WITH_DIAERESIS			(TCHAR) 0xEB	// Unicode 0x00EB
#define	LATIN_SMALL_LETTER_I_WITH_GRAVE				(TCHAR) 0xEC	// Unicode 0x00EC
#define	LATIN_SMALL_LETTER_I_WITH_ACUTE				(TCHAR) 0xED	// Unicode 0x00ED
#define	LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX		(TCHAR) 0xEE	// Unicode 0x00EE
#define	LATIN_SMALL_LETTER_I_WITH_DIAERESIS			(TCHAR) 0xEF	// Unicode 0x00EF
#define	LATIN_SMALL_LETTER_ETH						(TCHAR) 0xF0	// Unicode 0x00F0
#define	LATIN_SMALL_LETTER_N_WITH_TILDE				(TCHAR) 0xF1	// Unicode 0x00F1
#define	LATIN_SMALL_LETTER_O_WITH_GRAVE				(TCHAR) 0xF2	// Unicode 0x00F2
#define	LATIN_SMALL_LETTER_O_WITH_ACUTE				(TCHAR) 0xF3	// Unicode 0x00F3
#define	LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX		(TCHAR) 0xF4	// Unicode 0x00F4
#define	LATIN_SMALL_LETTER_O_WITH_TILDE				(TCHAR) 0xF5	// Unicode 0x00F5
#define	LATIN_SMALL_LETTER_O_WITH_DIAERESIS			(TCHAR) 0xF6	// Unicode 0x00F6
#define	DIVISION_SIGN								(TCHAR) 0xF7	// Unicode 0x00F7
#define	LATIN_SMALL_LETTER_O_WITH_STROKE			(TCHAR) 0xF8	// Unicode 0x00F8
#define	LATIN_SMALL_LETTER_U_WITH_GRAVE				(TCHAR) 0xF9	// Unicode 0x00F9
#define	LATIN_SMALL_LETTER_U_WITH_ACUTE				(TCHAR) 0xFA	// Unicode 0x00FA
#define	LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX		(TCHAR) 0xFB	// Unicode 0x00FB
#define	LATIN_SMALL_LETTER_U_WITH_DIAERESIS			(TCHAR) 0xFC	// Unicode 0x00FC
#define	LATIN_SMALL_LETTER_Y_WITH_ACUTE				(TCHAR) 0xFD	// Unicode 0x00FD
#define	LATIN_SMALL_LETTER_THORN					(TCHAR) 0xFE	// Unicode 0x00FE
#define	LATIN_SMALL_LETTER_Y_WITH_DIAERESIS			(TCHAR) 0xFF	// Unicode 0x00FF


#elif defined(RFD_BAUDOT_CONVERSION_UNICODE)

// Unicode
#define CHAR_NULL									(TCHAR) 0x0000
#define START_OF_HEADING							(TCHAR) 0x0001
#define START_OF_TEXT								(TCHAR) 0x0002
#define END_OF_TEXT									(TCHAR) 0x0003
#define END_OF_TRANSMISSION							(TCHAR) 0x0004
#define ENQUIRY										(TCHAR) 0x0005
#define ACKNOWLEDGE									(TCHAR) 0x0006
#define BELL										(TCHAR) 0x0007
#define BACKSPACE									(TCHAR) 0x0008
#define HORIZONTAL_TABULATION						(TCHAR) 0x0009
#define LINE_FEED									(TCHAR) 0x000A
#define VERTICAL_TABULATION							(TCHAR) 0x000B
#define FORM_FEED									(TCHAR) 0x000C
#define CARRIAGE_RETURN								(TCHAR) 0x000D
#define SHIFT_OUT									(TCHAR) 0x000E
#define SHIFT_IN									(TCHAR) 0x000F
#define DATA_LINK_ESCAPE							(TCHAR) 0x0010
#define DEVICE_CONTROL_ONE							(TCHAR) 0x0011
#define DEVICE_CONTROL_TWO							(TCHAR) 0x0012
#define DEVICE_CONTROL_THREE						(TCHAR) 0x0013
#define DEVICE_CONTROL_FOUR							(TCHAR) 0x0014
#define NEGATIVE_ACKNOWLEDGE						(TCHAR) 0x0015
#define SYNCHRONOUS_IDLE							(TCHAR) 0x0016
#define END_OF_TRANSMISSION_BLOCK					(TCHAR) 0x0017
#define CANCEL										(TCHAR) 0x0018
#define END_OF_MEDIUM								(TCHAR) 0x0019
#define SUBSTITUTE									(TCHAR) 0x001A
#define ESCAPE										(TCHAR) 0x001B
#define FILE_SEPARATOR								(TCHAR) 0x001C
#define GROUP_SEPARATOR								(TCHAR) 0x001D
#define RECORD_SEPARATOR							(TCHAR) 0x001E
#define UNIT_SEPARATOR								(TCHAR) 0x001F
#define SPACE										(TCHAR) 0x0020
#define EXCLAMATION_MARK							(TCHAR) 0x0021
#define QUOTATION_MARK								(TCHAR) 0x0022
#define NUMBER_SIGN									(TCHAR) 0x0023
#define DOLLAR_SIGN									(TCHAR) 0x0024
#define PERCENT_SIGN								(TCHAR) 0x0025
#define AMPERSAND									(TCHAR) 0x0026
#define APOSTROPHE									(TCHAR) 0x0027
#define LEFT_PARENTHESIS							(TCHAR) 0x0028
#define RIGHT_PARENTHESIS							(TCHAR) 0x0029
#define ASTERISK									(TCHAR) 0x002A
#define PLUS_SIGN									(TCHAR) 0x002B
#define COMMA										(TCHAR) 0x002C
#define HYPHEN_MINUS								(TCHAR) 0x002D
#define FULL_STOP									(TCHAR) 0x002E
#define SOLIDUS										(TCHAR) 0x002F
#define DIGIT_ZERO									(TCHAR) 0x0030
#define DIGIT_ONE									(TCHAR) 0x0031
#define DIGIT_TWO									(TCHAR) 0x0032
#define DIGIT_THREE									(TCHAR) 0x0033
#define DIGIT_FOUR									(TCHAR) 0x0034
#define DIGIT_FIVE									(TCHAR) 0x0035
#define DIGIT_SIX									(TCHAR) 0x0036
#define DIGIT_SEVEN									(TCHAR) 0x0037
#define DIGIT_EIGHT									(TCHAR) 0x0038
#define DIGIT_NINE									(TCHAR) 0x0039
#define COLON										(TCHAR) 0x003A
#define SEMICOLON									(TCHAR) 0x003B
#define LESS_THAN_SIGN								(TCHAR) 0x003C
#define EQUALS_SIGN									(TCHAR) 0x003D
#define GREATER_THAN_SIGN							(TCHAR) 0x003E
#define QUESTION_MARK								(TCHAR) 0x003F
#define COMMERCIAL_AT								(TCHAR) 0x0040
#define LATIN_CAPITAL_LETTER_A						(TCHAR) 0x0041
#define LATIN_CAPITAL_LETTER_B						(TCHAR) 0x0042
#define LATIN_CAPITAL_LETTER_C						(TCHAR) 0x0043
#define LATIN_CAPITAL_LETTER_D						(TCHAR) 0x0044
#define LATIN_CAPITAL_LETTER_E						(TCHAR) 0x0045
#define LATIN_CAPITAL_LETTER_F						(TCHAR) 0x0046
#define LATIN_CAPITAL_LETTER_G						(TCHAR) 0x0047
#define LATIN_CAPITAL_LETTER_H						(TCHAR) 0x0048
#define LATIN_CAPITAL_LETTER_I						(TCHAR) 0x0049
#define LATIN_CAPITAL_LETTER_J						(TCHAR) 0x004A
#define LATIN_CAPITAL_LETTER_K						(TCHAR) 0x004B
#define LATIN_CAPITAL_LETTER_L						(TCHAR) 0x004C
#define LATIN_CAPITAL_LETTER_M						(TCHAR) 0x004D
#define LATIN_CAPITAL_LETTER_N						(TCHAR) 0x004E
#define LATIN_CAPITAL_LETTER_O						(TCHAR) 0x004F
#define LATIN_CAPITAL_LETTER_P						(TCHAR) 0x0050
#define LATIN_CAPITAL_LETTER_Q						(TCHAR) 0x0051
#define LATIN_CAPITAL_LETTER_R						(TCHAR) 0x0052
#define LATIN_CAPITAL_LETTER_S						(TCHAR) 0x0053
#define LATIN_CAPITAL_LETTER_T						(TCHAR) 0x0054
#define LATIN_CAPITAL_LETTER_U						(TCHAR) 0x0055
#define LATIN_CAPITAL_LETTER_V						(TCHAR) 0x0056
#define LATIN_CAPITAL_LETTER_W						(TCHAR) 0x0057
#define LATIN_CAPITAL_LETTER_X						(TCHAR) 0x0058
#define LATIN_CAPITAL_LETTER_Y						(TCHAR) 0x0059
#define LATIN_CAPITAL_LETTER_Z						(TCHAR) 0x005A
#define LEFT_SQUARE_BRACKET							(TCHAR) 0x005B
#define REVERSE_SOLIDUS								(TCHAR) 0x005C
#define RIGHT_SQUARE_BRACKET						(TCHAR) 0x005D
#define CIRCUMFLEX_ACCENT							(TCHAR) 0x005E
#define LOW_LINE									(TCHAR) 0x005F
#define GRAVE_ACCENT								(TCHAR) 0x0060
#define LATIN_SMALL_LETTER_A						(TCHAR) 0x0061
#define LATIN_SMALL_LETTER_B						(TCHAR) 0x0062
#define LATIN_SMALL_LETTER_C						(TCHAR) 0x0063
#define LATIN_SMALL_LETTER_D						(TCHAR) 0x0064
#define LATIN_SMALL_LETTER_E						(TCHAR) 0x0065
#define LATIN_SMALL_LETTER_F						(TCHAR) 0x0066
#define LATIN_SMALL_LETTER_G						(TCHAR) 0x0067
#define LATIN_SMALL_LETTER_H						(TCHAR) 0x0068
#define LATIN_SMALL_LETTER_I						(TCHAR) 0x0069
#define LATIN_SMALL_LETTER_J						(TCHAR) 0x006A
#define LATIN_SMALL_LETTER_K						(TCHAR) 0x006B
#define LATIN_SMALL_LETTER_L						(TCHAR) 0x006C
#define LATIN_SMALL_LETTER_M						(TCHAR) 0x006D
#define LATIN_SMALL_LETTER_N						(TCHAR) 0x006E
#define LATIN_SMALL_LETTER_O						(TCHAR) 0x006F
#define LATIN_SMALL_LETTER_P						(TCHAR) 0x0070
#define LATIN_SMALL_LETTER_Q						(TCHAR) 0x0071
#define LATIN_SMALL_LETTER_R						(TCHAR) 0x0072
#define LATIN_SMALL_LETTER_S						(TCHAR) 0x0073
#define LATIN_SMALL_LETTER_T						(TCHAR) 0x0074
#define LATIN_SMALL_LETTER_U						(TCHAR) 0x0075
#define LATIN_SMALL_LETTER_V						(TCHAR) 0x0076
#define LATIN_SMALL_LETTER_W						(TCHAR) 0x0077
#define LATIN_SMALL_LETTER_X						(TCHAR) 0x0078
#define LATIN_SMALL_LETTER_Y						(TCHAR) 0x0079
#define LATIN_SMALL_LETTER_Z						(TCHAR) 0x007A
#define LEFT_CURLY_BRACKET							(TCHAR) 0x007B
#define VERTICAL_LINE								(TCHAR) 0x007C
#define RIGHT_CURLY_BRACKET							(TCHAR) 0x007D
#define TILDE										(TCHAR) 0x007E
#define CHAR_DELETE									(TCHAR) 0x007F
#define EURO_SIGN									(TCHAR) 0x20AC
//#define UNDEFINED									(TCHAR)
#define SINGLE_LOW_9_QUOTATION_MARK					(TCHAR) 0x201A
#define LATIN_SMALL_LETTER_F_WITH_HOOK				(TCHAR) 0x0192
#define DOUBLE_LOW_9_QUOTATION_MARK					(TCHAR) 0x201E
#define HORIZONTAL_ELLIPSIS							(TCHAR) 0x2026
#define DAGGER										(TCHAR) 0x2020
#define DOUBLE_DAGGER								(TCHAR) 0x2021
#define MODIFIER_LETTER_CIRCUMFLEX_ACCENT			(TCHAR) 0x02C6
#define PER_MILLE_SIGN								(TCHAR) 0x2030
#define LATIN_CAPITAL_LETTER_S_WITH_CARON			(TCHAR) 0x0160
#define SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK	(TCHAR) 0x2039
#define LATIN_CAPITAL_LIGATURE_OE					(TCHAR) 0x0152
//#define UNDEFINED									(TCHAR)
#define LATIN_CAPITAL_LETTER_Z_WITH_CARON			(TCHAR) 0x017D
//#define UNDEFINED									(TCHAR)
//#define UNDEFINED									(TCHAR)
#define LEFT_SINGLE_QUOTATION_MARK					(TCHAR) 0x2018
#define RIGHT_SINGLE_QUOTATION_MARK					(TCHAR) 0x2019
#define LEFT_DOUBLE_QUOTATION_MARK					(TCHAR) 0x201C
#define RIGHT_DOUBLE_QUOTATION_MARK					(TCHAR) 0x201D
#define BULLET										(TCHAR) 0x2022
#define EN_DASH										(TCHAR) 0x2013
#define EM_DASH										(TCHAR) 0x2014
#define SMALL_TILDE									(TCHAR) 0x02DC
#define TRADE_MARK_SIGN								(TCHAR) 0x2122
#define LATIN_SMALL_LETTER_S_WITH_CARON				(TCHAR) 0x0161
#define SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK	(TCHAR) 0x203A
#define LATIN_SMALL_LIGATURE_OE						(TCHAR) 0x0153
//#define UNDEFINED									(TCHAR)
#define LATIN_SMALL_LETTER_Z_WITH_CARON				(TCHAR) 0x017E
#define LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS		(TCHAR) 0x0178
#define NO_BREAK_SPACE								(TCHAR) 0x00A0
#define INVERTED_EXCLAMATION_MARK					(TCHAR) 0x00A1
#define CENT_SIGN									(TCHAR) 0x00A2
#define POUND_SIGN									(TCHAR) 0x00A3
#define CURRENCY_SIGN								(TCHAR) 0x00A4
#define YEN_SIGN									(TCHAR) 0x00A5
#define BROKEN_BAR									(TCHAR) 0x00A6
#define SECTION_SIGN								(TCHAR) 0x00A7
#define DIAERESIS									(TCHAR) 0x00A8
#define COPYRIGHT_SIGN								(TCHAR) 0x00A9
#define FEMININE_ORDINAL_INDICATOR					(TCHAR) 0x00AA
#define LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	(TCHAR) 0x00AB
#define NOT_SIGN									(TCHAR) 0x00AC
#define SOFT_HYPHEN									(TCHAR) 0x00AD
#define REGISTERED_SIGN								(TCHAR) 0x00AE
#define MACRON										(TCHAR) 0x00AF
#define DEGREE_SIGN									(TCHAR) 0x00B0
#define PLUS_MINUS_SIGN								(TCHAR) 0x00B1
#define SUPERSCRIPT_TWO								(TCHAR) 0x00B2
#define SUPERSCRIPT_THREE							(TCHAR) 0x00B3
#define ACUTE_ACCENT								(TCHAR) 0x00B4
#define MICRO_SIGN									(TCHAR) 0x00B5
#define PILCROW_SIGN								(TCHAR) 0x00B6
#define MIDDLE_DOT									(TCHAR) 0x00B7
#define CEDILLA										(TCHAR) 0x00B8
#define SUPERSCRIPT_ONE								(TCHAR) 0x00B9
#define MASCULINE_ORDINAL_INDICATOR					(TCHAR) 0x00BA
#define RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	(TCHAR) 0x00BB
#define VULGAR_FRACTION_ONE_QUARTER					(TCHAR) 0x00BC
#define VULGAR_FRACTION_ONE_HALF					(TCHAR) 0x00BD
#define VULGAR_FRACTION_THREE_QUARTERS				(TCHAR) 0x00BE
#define INVERTED_QUESTION_MARK						(TCHAR) 0x00BF
#define LATIN_CAPITAL_LETTER_A_WITH_GRAVE			(TCHAR) 0x00C0
#define LATIN_CAPITAL_LETTER_A_WITH_ACUTE			(TCHAR) 0x00C1
#define LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX		(TCHAR) 0x00C2
#define LATIN_CAPITAL_LETTER_A_WITH_TILDE			(TCHAR) 0x00C3
#define LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS		(TCHAR) 0x00C4
#define LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE		(TCHAR) 0x00C5
#define LATIN_CAPITAL_LETTER_AE						(TCHAR) 0x00C6
#define LATIN_CAPITAL_LETTER_C_WITH_CEDILLA			(TCHAR) 0x00C7
#define LATIN_CAPITAL_LETTER_E_WITH_GRAVE			(TCHAR) 0x00C8
#define LATIN_CAPITAL_LETTER_E_WITH_ACUTE			(TCHAR) 0x00C9
#define LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX		(TCHAR) 0x00CA
#define LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS		(TCHAR) 0x00CB
#define LATIN_CAPITAL_LETTER_I_WITH_GRAVE			(TCHAR) 0x00CC
#define LATIN_CAPITAL_LETTER_I_WITH_ACUTE			(TCHAR) 0x00CD
#define LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX		(TCHAR) 0x00CE
#define LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS		(TCHAR) 0x00CF
#define LATIN_CAPITAL_LETTER_ETH					(TCHAR) 0x00D0
#define LATIN_CAPITAL_LETTER_N_WITH_TILDE			(TCHAR) 0x00D1
#define LATIN_CAPITAL_LETTER_O_WITH_GRAVE			(TCHAR) 0x00D2
#define LATIN_CAPITAL_LETTER_O_WITH_ACUTE			(TCHAR) 0x00D3
#define LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX		(TCHAR) 0x00D4
#define LATIN_CAPITAL_LETTER_O_WITH_TILDE			(TCHAR) 0x00D5
#define LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS		(TCHAR) 0x00D6
#define MULTIPLICATION_SIGN							(TCHAR) 0x00D7
#define LATIN_CAPITAL_LETTER_O_WITH_STROKE			(TCHAR) 0x00D8
#define LATIN_CAPITAL_LETTER_U_WITH_GRAVE			(TCHAR) 0x00D9
#define LATIN_CAPITAL_LETTER_U_WITH_ACUTE			(TCHAR) 0x00DA
#define LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX		(TCHAR) 0x00DB
#define LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS		(TCHAR) 0x00DC
#define LATIN_CAPITAL_LETTER_Y_WITH_ACUTE			(TCHAR) 0x00DD
#define LATIN_CAPITAL_LETTER_THORN					(TCHAR) 0x00DE
#define LATIN_SMALL_LETTER_SHARP_S					(TCHAR) 0x00DF
#define LATIN_SMALL_LETTER_A_WITH_GRAVE				(TCHAR) 0x00E0
#define LATIN_SMALL_LETTER_A_WITH_ACUTE				(TCHAR) 0x00E1
#define LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX		(TCHAR) 0x00E2
#define LATIN_SMALL_LETTER_A_WITH_TILDE				(TCHAR) 0x00E3
#define LATIN_SMALL_LETTER_A_WITH_DIAERESIS			(TCHAR) 0x00E4
#define LATIN_SMALL_LETTER_A_WITH_RING_ABOVE		(TCHAR) 0x00E5
#define LATIN_SMALL_LETTER_AE						(TCHAR) 0x00E6
#define LATIN_SMALL_LETTER_C_WITH_CEDILLA			(TCHAR) 0x00E7
#define LATIN_SMALL_LETTER_E_WITH_GRAVE				(TCHAR) 0x00E8
#define LATIN_SMALL_LETTER_E_WITH_ACUTE				(TCHAR) 0x00E9
#define LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX		(TCHAR) 0x00EA
#define LATIN_SMALL_LETTER_E_WITH_DIAERESIS			(TCHAR) 0x00EB
#define LATIN_SMALL_LETTER_I_WITH_GRAVE				(TCHAR) 0x00EC
#define LATIN_SMALL_LETTER_I_WITH_ACUTE				(TCHAR) 0x00ED
#define LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX		(TCHAR) 0x00EE
#define LATIN_SMALL_LETTER_I_WITH_DIAERESIS			(TCHAR) 0x00EF
#define LATIN_SMALL_LETTER_ETH						(TCHAR) 0x00F0
#define LATIN_SMALL_LETTER_N_WITH_TILDE				(TCHAR) 0x00F1
#define LATIN_SMALL_LETTER_O_WITH_GRAVE				(TCHAR) 0x00F2
#define LATIN_SMALL_LETTER_O_WITH_ACUTE				(TCHAR) 0x00F3
#define LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX		(TCHAR) 0x00F4
#define LATIN_SMALL_LETTER_O_WITH_TILDE				(TCHAR) 0x00F5
#define LATIN_SMALL_LETTER_O_WITH_DIAERESIS			(TCHAR) 0x00F6
#define DIVISION_SIGN								(TCHAR) 0x00F7
#define LATIN_SMALL_LETTER_O_WITH_STROKE			(TCHAR) 0x00F8
#define LATIN_SMALL_LETTER_U_WITH_GRAVE				(TCHAR) 0x00F9
#define LATIN_SMALL_LETTER_U_WITH_ACUTE				(TCHAR) 0x00FA
#define LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX		(TCHAR) 0x00FB
#define LATIN_SMALL_LETTER_U_WITH_DIAERESIS			(TCHAR) 0x00FC
#define LATIN_SMALL_LETTER_Y_WITH_ACUTE				(TCHAR) 0x00FD
#define LATIN_SMALL_LETTER_THORN					(TCHAR) 0x00FE
#define LATIN_SMALL_LETTER_Y_WITH_DIAERESIS			(TCHAR) 0x00FF

#else
	#error "Baudot conversion character set definition required"
#endif


#ifdef __cplusplus
}
#endif

#endif // RFD_BAUDOT_H