////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	multifile_manager\mfm_consumer.h
///
/// @brief	Declares the multifile manager class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2013 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef MFM_CONSUMER_H
#define MFM_CONSUMER_H

#include "rfd_config.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

///////////////////////////
// Task/thread Stack Sizes
///////////////////////////
#define MFM_FILE_CONSUMER_THREAD_STACK_SIZE  8192

/////////////////////
// Thread Priorities
/////////////////////
#define MFM_FILE_CONSUMER_THREAD_PRIORITY    RFD_THREAD_PRIORITY_BELOW_NORMAL

// Within this callback:
// 1. MFM first calls the "data service" file transfer callback fcn (fcn pointer is under mfmManagerFileTransferCallbackArg),
// 2. MFM posts the file and consumer handle info to MFM consumer que.
typedef void (*MFM_MANAGER_FILE_TRANSFER_CALLBACK_FCN) (
        RFD_CONSUMER_THREAD_DATA_HANDLE rfdFileConsumerHandle, // the rfd consumer handle corresponding to the transferred file.
        const TCHAR storedFileName[],
        RFD_CONSUMER_FILE_INFO_STRUCT * consumerFileInfo,
        void * mfmManagerFileTransferCallbackArg );

// MFM_FILE_CONSUMER_LL_CONTROL_STRUCT :
// Contains variables that have scope over the lifetime of the
// MFM File Consumer Thread Run function.
typedef struct  {

	RFD_MULTI_WAIT_EVENT_STRUCT * multiCollectWaitEventObject;

} MFM_FILE_CONSUMER_LL_CONTROL_STRUCT;

// File Consumer thread main handle
typedef struct {
	RFD_EVENT_HANDLE exitRequestEvent;		// signal from the manager to the rfdr consumer to shutdown the consumer thread.
	RFD_EVENT_HANDLE errorExitEvent;        // signal error exit event TO the manager
	RFD_THREAD_HANDLE  consumerThread;		// App File Consumer Thread Handle.
	DWORD   consumerThreadId;				// App File Consumer Thread ID.
    RFD_LLIST_HANDLE rfdFileConsumerHandleList; // List of RFD_CONSUMER_THREAD_DATA_HANDLE handles for RFD usage.
    MFM_MANAGER_FILE_TRANSFER_CALLBACK_FCN mfmManagerFileTransferCallbackFcn;
    void * mfmManagerFileTransferCallbackArg;
    INT32 fileReadyPollIntervalMillisec; // Polling interval in File Consumer run loop for New File Ready events.
    BOOL isAltSingleThreadMode;             // TRUE if RFD operation is configured for the alternate single-threaded mode.
    BOOL isRunning;                         // TRUE if running (afer successful call to MFM_StartFileConsumer(), before MFM_StopFileConsumer().

} MFM_FILE_CONSUMER_DATA_STRUCT, *MFM_FILE_CONSUMER_HANDLE;

// File Consumer File Transfer Callback Argument structure
typedef struct {
    BOOL isFileProcessed;  // output
	MFM_FILE_CONSUMER_HANDLE hConsumer;
    RFD_CONSUMER_THREAD_DATA_HANDLE rfdFileConsumerHandle;

} MFM_CONSUMER_FILE_TRANSFER_CALLBACK_ARG_STRUCT;

///////////////////////////////////////////////////////////////////////////////

DWORD RFD_PLATFORM_API MFM_FileConsumer( LPVOID lpParam ) ;

RFD_STATUS MFM_FileConsumerOpenLL(
    MFM_FILE_CONSUMER_HANDLE hConsumer,
    RFD_STATUS * statusPtr,
    BOOL *isThreadExitRequestedPtr
        );

RFD_STATUS MFM_FileConsumerCloseLL(
    MFM_FILE_CONSUMER_HANDLE hConsumer,
    RFD_STATUS * statusPtr
        );

RFD_STATUS MFM_FileConsumerRunLL(
    MFM_FILE_CONSUMER_HANDLE hConsumer,
    RFD_STATUS * statusPtr,
    BOOL *isThreadExitRequestedPtr
        );

RFD_STATUS MFM_FileConsumerErrorCheck(MFM_FILE_CONSUMER_HANDLE mfmFileConsumerHandle, INT32 timeOutMilliSeconds);
RFD_STATUS MFM_OpenFileConsumer(MFM_FILE_CONSUMER_HANDLE * mfmFileConsumerHandlePtr);
RFD_STATUS MFM_OpenFileConsumerExt(
    MFM_FILE_CONSUMER_HANDLE * mfmFileConsumerHandlePtr,
    BOOL isAltSingleThreadMode
        );
RFD_STATUS MFM_CloseFileConsumer(MFM_FILE_CONSUMER_HANDLE mfmFileConsumerHandle);
RFD_STATUS MFM_StartFileConsumer(MFM_FILE_CONSUMER_HANDLE mfmFileConsumerHandle);
RFD_STATUS MFM_StopFileConsumer(MFM_FILE_CONSUMER_HANDLE mfmFileConsumerHandle);
RFD_STATUS MFM_RunFileConsumer(
    MFM_FILE_CONSUMER_HANDLE hConsumer,
    BOOL *isThreadExitRequestedPtr
        );
RFD_STATUS MFM_CreateFileConsumerExt(
    MFM_FILE_CONSUMER_HANDLE * mfmFileConsumerHandlePtr,
    RFD_CONSUMER_THREAD_DATA_HANDLE rfdFileConsumerHandle[],
    UINT16 numRfdFileConsumerHandles,
    MFM_MANAGER_FILE_TRANSFER_CALLBACK_FCN mfmManagerFileTransferCallbackFcn,
    void * mfmManagerFileTransferCallbackArg,
    INT32 fileReadyPollIntervalMillisec,
    BOOL isAltSingleThreadMode
        );
RFD_STATUS MFM_DeleteFileConsumer(
    MFM_FILE_CONSUMER_HANDLE mfmFileConsumerHandle );

#ifdef __cplusplus
}
#endif

#endif // MFM_CONSUMER_H