/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*DESCRIPTION
*
*       This module will contain all the OS specific time APIs.
*
*******************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>

#define OSAL_TRACE_ENABLE   0
#include "osal_trace.h"

#include "standard.h"
#include "osal.h"

#include "os_version.h"
#include "os.h"

#include "os_time_.h"
#include "_os_time_.h"

/*******************************************************************************
*
*   OS_eGetTime
*
*   This function needs to provide the number of seconds and msec which have
*   elapsed in a monotonic fashion since boot.
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OS_eGetTime (
    UN32 *pun32Sec,
    UN16 *pun16MSec
        )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_SUCCESS;
    struct timespec time;
    int iRetval;

    TRACE_START();

    // Get the current time of a clock
    // We use the POSIX clock_gettime() call along with
    // MONOTONIC clock to make sure time doesn't change
    // on us unexpectedly.
#ifdef __INTEGRITY
    // Integrity OS does not support CLOCK_MONOTONIC, so using
    // the only possible ID
    iRetval = clock_gettime(CLOCK_REALTIME, &time);
#else
    iRetval = clock_gettime(CLOCK_MONOTONIC, &time);
#endif
    if(iRetval != EOK)
    {
        // Error!
        print_err(iRetval, "Error! clock_gettime()");
        eReturnCode = OSAL_ERROR;
    }
    else
    {
        // Check if input pointer provided
        if(pun32Sec != NULL)
        {
            // Return seconds elapsed
            *pun32Sec = time.tv_sec;
        }

        // Check if input pointer provided
        if(pun16MSec != NULL)
        {
            // Return milliseconds elapsed
            // Convert nsec to msec.
            *pun16MSec = (time.tv_nsec / 1000000L);
        }
    }

    TRACE_END();
    return eReturnCode;
}
