/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OS_GENERAL_H_
#define OS_GENERAL_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <pthread.h>

#include "standard.h"
#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#define OS_TASK_SUSPEND_SIGNAL SIGUSR1
#define OS_TASK_RESUME_SIGNAL SIGUSR2

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct os_general_struct
{
    // Critical Section Elements
    pthread_mutex_t tCriticalSectionMutex;			 // Mutex

    // Thread specific key, used to lookup thread
    // specific data, specifically the thread os-layer
    // object which maintains information about the thread.
    pthread_key_t tThreadSpecificObjectKey;

} OS_GENERAL_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

extern OS_GENERAL_STRUCT GsCtrl;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN OS_bStart (
    OSAL_START_HANDLER tStartHandler,
    const void *pvStartHandlerArg
        );

void OS_vEnterCriticalSection ( void );

void OS_vExitCriticalSection ( void );

OSAL_RETURN_CODE_ENUM OS_eDisableMultitasking ( void );

OSAL_RETURN_CODE_ENUM OS_eEnableMultitasking ( void );

OSAL_RETURN_CODE_ENUM OS_eGetUtilizationCPU(
    UN8 *pun8Current,
    UN8 *pun8Max,
    UN8 *pun8Min
        );

void OS_vResetUtilizationCPU ( void );

void OS_vUpdateCPUStats ( void );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OS_GENERAL_H_
