/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OS_FS_H_
#define OS_FS_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#if OSAL_FILE_SYSTEM == 1

BOOLEAN OS_bFileSystemStart ( void );
BOOLEAN OS_bFileSystemStop ( void );
void OS_vFileSystemVolumes ( FILE *psFile );
BOOLEAN OS_bFileSystemVolumeInfo ( FILE *psFile, const char *pcVolName );
BOOLEAN OS_bFileSystemDirectory ( FILE *psFile, const char *pcPathName );
BOOLEAN OS_bFileSystemMakeDir ( const char *pcDirName );
BOOLEAN OS_bFileSystemRemoveDir ( const char *pcDirName );
OSAL_RETURN_CODE_ENUM OS_eFileSystemGetDirItems (
    OSAL_OBJECT_HDL *phDirItems, const char *pcPathName,
    OSAL_FS_FILE_QUALIFIER bFileQualifierFunc, void *pvQualiferArg);
BOOLEAN OS_bFileSystemTruncateFile ( FILE *psFile, size_t tNewSize );
BOOLEAN OS_bFileSystemGetFileSize ( FILE *psFile, size_t *ptFileSize );
BOOLEAN OS_bFileSystemGetFileAttributes ( const char *pcPath,
										  UN8 *pun8FileAttributes );
BOOLEAN OS_bFileSystemSetFileAttributes ( const char *pcPath,
										  UN8 un8FileAttributes );
BOOLEAN OS_bFileSystemSyncFile ( FILE *psFile );
BOOLEAN OS_bFileSystemUnconditionalFileUnlink ( const char *pcPath );

#endif /* OSAL_FILE_SYSTEM == 1 */

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OS_FS_H_
