/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OS_TASK_H_
#define _OS_TASK_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <pthread.h>

#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct os_task_object_struct
{
    // Pointer to this thread's name
    const char *pacName;

    // This is the task function to run
    OSAL_TASK_HANDLER tTaskHandler;

    // This is the argument for the task function
    void *pvTaskHandlerArgument;

    // Caller requested stack size (stack may actually be larger
    // depending on requirements since stacks are allowed to grow
    // as needed).
    UN32 un32StackSize;

    // This is a copy of the handle to the parent OSAL task handle
    // The parent handle is placed here for easy reference when
    // looking up the current task handle. Since OSAL has no native
    // way of knowing which task is currently running, it must rely
    // on the underlying OS to report this. If this handle were not
    // recorded here then this would force a task lookup each time
    // the current task handle was requested.
    OSAL_OBJECT_HDL hParentObject;

    // This thread's id
    pthread_t tThreadId;

#ifndef __QNX__
    // Thread ID of the task (actually it is TID, but not PID)
    pid_t tThreadPid;

    // Mutex to synchronize thread ID acquiring
    pthread_mutex_t tThreadPidMutex;
    // Condition to use with TID mutex
    pthread_cond_t tThreadPidCond;

    // Mutex to synchronize priority setting
    pthread_mutex_t tThreadPriorityMutex;
    // Condition to use with Priority mutex
    pthread_cond_t tThreadPriorityCond;
    // Flag which is set when priority is assigned for the thread
    BOOLEAN bPrioritySet;

    // Converted priority (Linux' "nice" value)
    int   iPriority;
#endif

} OS_TASK_OBJECT_STRUCT;


#if (GPROF_ENABLED == 1)
/* Our data structure passed to the wrapper */
typedef struct wrapper_s
{
    void * (*start_routine)(void *);
    void *arg;

    pthread_mutex_t lock;
    pthread_cond_t  wait;

    struct itimerval itimer;

} wrapper_t;
#endif

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static int OS_vThreadSetName(const char *pcThreadName);

static void *OS_vTaskShell( void *pvArg );

static BOOLEAN OS_bMapPriority(
    OSAL_TASK_PRIORITY_ENUM ePriority,
    int *piPriority
        );

#if (GPROF_ENABLED == 1)
static int pthread_create_wrapper(
	pthread_t *__restrict thread,
    __const pthread_attr_t *__restrict attr,
    void * (*start_routine)(void *),
    void *__restrict arg
    	);

static void *wrapper_routine(void *data);
#endif

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OS_TASK_H_
