/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OS_SEM_H_
#define _OS_SEM_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <pthread.h>
#include "standard.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Using the MONOTONIC clock rather than the REALTIME clock
// forces this to be immune to external system time changes.
#ifdef __INTEGRITY
#define OS_SEM_CLOCK    (CLOCK_REALTIME)
#else
#define OS_SEM_CLOCK    (CLOCK_MONOTONIC)
#endif

// There are 1000000 nano-seconds per msec.
#define NSEC_PER_MSEC (1000000)
// There are 1000 milli-seconds per second.
#define MSEC_PER_SEC (1000)

  /**************/
 /** TYPEDEFS **/
/**************/

// Semaphore implementation structure
typedef struct os_sem_struct
{
    // Protects access to the data 'un32Available'
    pthread_mutex_t mutex;

    // Signals a change to the data 'un32Available'
    pthread_cond_t cond;

    // Condition variable attribute
    pthread_condattr_t cond_attr;

    // This is the predicate which is the data being protected
    // by the mutex. It tracks the total number of resources available
    // as well as the number consumed.
    UN32 un32Resources;
    volatile UN32 un32Available;
    volatile UN32 un32Waiters;

    // Flag error condition
    BOOLEAN bDestroy;

    UN32 un32Options;

} OS_SEM_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OS_SEM_H_
