/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OS_MEM_H_
#define _OS_MEM_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stddef.h>
#include "standard.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

  /***************/
 /** VARIABLES **/
/***************/

static int giMemFD = -1;

  /************/
 /** MACROS **/
/************/
#define OSAL_MEMORY_CHECK_NONE   0
#define OSAL_MEMORY_CHECK_FULL   1
#define OSAL_MEMORY_CHECK_END    2

#define OSAL_MEMORY_CHECK        OSAL_MEMORY_CHECK_FULL

#if OSAL_DEBUG != 1
#undef OSAL_MEMORY_CHECK
#define OSAL_MEMORY_CHECK        OSAL_MEMORY_CHECK_NONE
#endif

// Size_t is 4-byte integer
#define DBG_SAFETY_PATTERN       ((size_t)0xAAAAAAAA)
#define DBG_SAFETY_PATTERN_FREED ((size_t)0xDCDCDCDC)

  /****************/
 /** PROTOTYPES **/
/****************/

static void *OS_pvMapPhysicalMemory (
    unsigned int uiOffset,
    size_t tSize,
    int iProtection
        );

static void OS_vUnMapPhysicalMemory (
    void *pvPtr,
    size_t tSize
        );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OS_MEM_H_
