/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OS_H_
#define _OS_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "osal.h"

#include "os_general.h"
#include "os_task_.h"
#include "os_sem_.h"
#include "os_time_.h"
#include "os_mem_.h"
#include "os_fs.h"
#include "os_stdio.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/*
    OS API Object Definition
*/

const OS_INTF_STRUCT OS =
{
    /*
        General APIs
    */

    /*.bStart = */OS_bStart,
    /*.vEnterCriticalSection = */OS_vEnterCriticalSection,
    /*.vExitCriticalSection = */OS_vExitCriticalSection,
    /*.eGetUtilizationCPU = */OS_eGetUtilizationCPU,
    /*.vResetUtilizationCPU = */OS_vResetUtilizationCPU,
    /*.vUpdateCPUState = */OS_vUpdateCPUStats,

    /*
        Task Management APIs
    */

    /*.eTaskCreate = */OS_eTaskCreate,
    /*.eTaskDelete = */OS_eTaskDelete,
    /*.eTaskSuspend = */OS_eTaskSuspend,
    /*.eTaskResume = */OS_eTaskResume,
    /*.eTaskDelay = */OS_eTaskDelay,
    /*.vTaskYield = */OS_vTaskYield,
    /*.eTaskChangePriority = */OS_eTaskChangePriority,
    /*.hTaskGetHandle = */OS_hTaskGetHandle,
    /*.eTaskGetInfo = */OS_eTaskGetInfo,
    /*.bTaskGetId = */OS_bTaskGetId,
    /*.eTaskList = */OS_eTaskList,

    /*
        Task Synchronization APIs
    */

    /*.eSemCreate = */OS_eSemCreate,
    /*.eSemDelete = */OS_eSemDelete,
    /*.eSemGive = */OS_eSemGive,
    /*.eSemTake = */OS_eSemTake,

    /*
        Time Management APIs
    */

    /*.eGetTime = */OS_eGetTime,

    /*
        Memory Management and Interface APIs
    */

    /*.bMemRead8 = */OS_bMemRead8,
    /*.bMemWrite8 = */OS_bMemWrite8,
    /*.bMemRead16 = */OS_bMemRead16,
    /*.bMemWrite16 = */OS_bMemWrite16,
    /*.bMemRead32 = */OS_bMemRead32,
    /*.bMemWrite32 = */OS_bMemWrite32,
    /*.bPortRead8 = */OS_bPortRead8,
    /*.bPortWrite8 = */OS_bPortWrite8,
    /*.bPortRead16 = */OS_bPortRead16,
    /*.bPortWrite16 = */OS_bPortWrite16,
    /*.bPortRead32 = */OS_bPortRead32,
    /*.bPortWrite32 = */OS_bPortWrite32,
    /*.bMemCpy = */OS_bMemCpy,
    /*.bMemSet = */OS_bMemSet,
    /*.pvMemoryAllocate = */OS_pvMemoryAllocate,
    /*.vMemoryFree = */OS_vMemoryFree,
    /*.un32TotalSystemBytes = */OS_un32TotalSystemBytes,

    /*
        File System APIs
    */
#if OSAL_FILE_SYSTEM == 1
    /*.bFileSystemStart = */OS_bFileSystemStart,
    /*.bFileSystemStop = */OS_bFileSystemStop,
    /*.vFileSystemVolumes = */OS_vFileSystemVolumes,
    /*.bFileSystemVolumeInfo = */OS_bFileSystemVolumeInfo,
    /*.bFileSystemDirectory = */OS_bFileSystemDirectory,
    /*.bFileSystemMakeDir = */OS_bFileSystemMakeDir,
    /*.bFileSystemRemoveDir = */OS_bFileSystemRemoveDir,
    /*.eFileSystemGetDirItems = */OS_eFileSystemGetDirItems,
    /*.eFileSystemReleaseDirItems = */NULL,
    /*.bFileSystemTruncateFile = */OS_bFileSystemTruncateFile,
    /*.bFileSystemGetFileSize = */OS_bFileSystemGetFileSize,
    /*.bFileSystemGetFileAttributes = */OS_bFileSystemGetFileAttributes,
    /*.bFileSystemSetFileAttributes = */OS_bFileSystemSetFileAttributes,
    /*.bFileSystemSyncFile = */OS_bFileSystemSyncFile,
    /*.bFileSystemUnconditionalFileUnlink = */OS_bFileSystemUnconditionalFileUnlink
#endif
};

/*
 *  OS-Specific File System Implementation
 */
const OSAL_FILE_INTERFACE_STRUCT GsFSIntf =
{
    (void* (*)(const char *pcFileName, const char *pcMode))
        OS_FOpen, // fopen
    (int (*)(void *psFile))
        OS_FClose, // fclose
    (size_t (*)(void *pvDst, size_t tSize, size_t tNumObj, void *psFile))
        OS_FRead, // fread
    (size_t (*)(const void *pvSrc, size_t tSize, size_t tNumObj, void *psFile))
        OS_FWrite, // fwrite
    (long (*)(void *psFile))
        OS_FTell, // ftell
    (int (*)(void *psFile, int iCmd, va_list *ptList))
    	OS_Ioctl, // ioctl
    (int (*)(void *psFile, long lOffset, int iMode))
        OS_FSeek, // fseek
    (int (*)(const char *pcFileName))
        OS_Remove, // remove
    (int (*)(const char *pcOldFileName, const char *pcNewFileName))
        OS_Rename, // rename
    (int (*)(void *psFile))
        OS_FFlush, // fflush
    (int (*)(void *psFile))
        OS_FError, // ferror
    (int (*)(void *psFile))
        OS_FEof, // feof
    (void (*)(void *psFile))
        OS_Clearerr // clearerr
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OS_H_
