/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

/*********************************/
/** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_TIMER_H_
#define OSAL_TIMER_H_

/**************/
/** INCLUDES **/
/**************/
#include <stdlib.h>
#include <time.h>

#include "standard.h"

#include "osal.h"

/**********************/
/** GLOBAL CONSTANTS **/
/**********************/

/*********************/
/** GLOBAL TYPEDEFS **/
/*********************/

/****************************/
/** GLOBAL UNION TEMPLATES **/
/****************************/

/**********************/
/** GLOBAL VARIABLES **/
/**********************/

/*******************/
/** GLOBAL MACROS **/
/*******************/

/***********************/
/** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN OSALT_bTaskInstall( OSAL_TASK_PRIORITY_ENUM ePriority );

void OSALT_vTaskUninstall( void );

OSAL_RETURN_CODE_ENUM OSAL_eTimerCreate (
    OSAL_OBJECT_HDL *phTimerObj,
    const char *pacName,
    OSAL_TIMER_HANDLER tTimerHandler,
    const void *pvTimerHandlerArgument
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerDelete (
    OSAL_OBJECT_HDL hTimerObj
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerSetHandler (
    OSAL_OBJECT_HDL hTimerObj,
    OSAL_TIMER_HANDLER tTimerHandler
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerSetHandlerArg (
    OSAL_OBJECT_HDL hTimerObj,
    const void *pvTimerHandlerArgument
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerStartRelative (
    OSAL_OBJECT_HDL hTimerObj,
    UN32 un32InitialOffset,
    UN32 un32PeriodicRate
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerStartAbsolute (
    OSAL_OBJECT_HDL hTimerObj,
    UN8 un8Second,
    UN8 un8Minute,
    UN8 un8Hour,
    UN16 un16Year,
    UN8 un8Day,
    UN8 un8Month
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerStop (
    OSAL_OBJECT_HDL hTimerObj
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerRemaining (
    OSAL_OBJECT_HDL hTimerObj,
    UN32 *pun32TimeRemaining
    );

OSAL_OBJECT_HDL OSAL_hTimerGetHandleByName (
    const char *pacName
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerGetInfo (
    OSAL_OBJECT_HDL hTimerObj,
    OSAL_TIMER_INFO_STRUCT *psTimerInfo
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimerList ( void );

/*****************************/
/** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_TIMER_H_
