/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

/*********************************/
/** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_TIME_H_
#define OSAL_TIME_H_

/**************/
/** INCLUDES **/
/**************/
#include <stdlib.h>
#include <time.h>

#include "standard.h"

#include "osal.h"

/**********************/
/** GLOBAL CONSTANTS **/
/**********************/

/*********************/
/** GLOBAL TYPEDEFS **/
/*********************/

/****************************/
/** GLOBAL UNION TEMPLATES **/
/****************************/

/**********************/
/** GLOBAL VARIABLES **/
/**********************/

/*******************/
/** GLOBAL MACROS **/
/*******************/

/***********************/
/** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN OSALT_bTimeInitialize( void );

void OSALT_vTimeUninitialize( void );

OSAL_RETURN_CODE_ENUM OSAL_eTimeSet (
    // since 00:00:00 UTC January 1, 1970
    // rolls over in 2106
    UN32 un32Seconds
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimeSetGMToffset (
    N32 n32Minutes
        );

OSAL_RETURN_CODE_ENUM OSAL_eTimeSetDSTadjustment (
    UN32 un32Minutes
        );

OSAL_RETURN_CODE_ENUM OSAL_eTimeGet (
    // since 00:00:00 UTC January 1, 1970
    // rolls over in 2106
    UN32 *pun32Seconds
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimeGetLocal (
    // since 00:00:00 UTC January 1, 1970
    // rolls over in 2106
    UN32 *pun32Seconds
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimeGetGMToffset (
    N32 *pn32Minutes
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimeGetDSTadjustment (
    UN32 *pun32Minutes
    );

void OSAL_vTimeUp (
    UN32 *pun32Seconds,
    UN16 *pun16Msecs
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimeSetRegisterNotification (
    OSAL_TIME_NOTIFICATION_OBJECT *phNotificationHandle,
    OSAL_TIME_UPDATE_MASK tUpdateMask,
    OSAL_TIME_UPDATE_HANDLER vHandler,
    void *pvHandlerArg
    );

OSAL_RETURN_CODE_ENUM OSAL_eTimeSetUnRegisterNotification (
    OSAL_TIME_NOTIFICATION_OBJECT hNotificationHandle
    );

void OSAL_vParseTime(char *pcCmdLine, TIME_T *ptTod, struct tm *psTime);

struct tm *OSAL_gmtime_r(const TIME_T *ptTime, struct tm *psTime);

struct tm *OSAL_localtime_r(const TIME_T *ptTime, struct tm *psTime);

TIME_T OSAL_mktime(struct tm *psTime);

double OSAL_difftime(TIME_T time1, TIME_T time0);

char *OSAL_asctime_r(const struct tm *psTime, char *pacBuf);

char *OSAL_ctime_r(const TIME_T *psTime, char *pacBuf);

/*****************************/
/** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_TIME_H_
