/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_TASK_H_
#define OSAL_TASK_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_RETURN_CODE_ENUM OSAL_eTaskCreate (
    OSAL_OBJECT_HDL *phTaskObj,
    const char *pacName,
    OSAL_TASK_HANDLER tTaskHandler,
    void *pvTaskHandlerArgument,
    UN32 un32StackSize,
    OSAL_TASK_PRIORITY_ENUM ePriority,
    UN32 un32Options
        );

OSAL_RETURN_CODE_ENUM OSAL_eTaskDelete (
    OSAL_OBJECT_HDL hTaskObj
        );

OSAL_RETURN_CODE_ENUM OSAL_eTaskSuspend (
    OSAL_OBJECT_HDL hTaskObj
        );

OSAL_RETURN_CODE_ENUM OSAL_eTaskResume (
    OSAL_OBJECT_HDL hTaskObj
        );

OSAL_RETURN_CODE_ENUM OSAL_eTaskDelay (
    UN32 un32Milliseconds
        );

void OSAL_vTaskYield ( void );

OSAL_RETURN_CODE_ENUM OSAL_eTaskChangePriority (
    OSAL_OBJECT_HDL hTaskObj, OSAL_TASK_PRIORITY_ENUM eNewPriority
        );

OSAL_RETURN_CODE_ENUM OSAL_eTaskRegister (
    UN16 un16ReportingInterval,
    OSAL_SLEEP_HANDLER tSleepHandler,
    OSAL_WAKEUP_HANDLER tWakeupHandler,
    OSAL_SHUTDOWN_HANDLER tShutdownHandler,
    void *pvHandlerArgument
        );

OSAL_RETURN_CODE_ENUM OSAL_eTaskUnregister ( void );

OSAL_RETURN_CODE_ENUM OSAL_eTaskReport (
    N32 n32Status
        );

OSAL_OBJECT_HDL OSAL_hTaskGetHandle ( void );

OSAL_OBJECT_HDL OSAL_hTaskGetHandleByName (
    const char *pacName
        );

OSAL_RETURN_CODE_ENUM OSAL_eTaskGetInfo  (
    OSAL_OBJECT_HDL hTaskObj,
    OSAL_TASK_INFO_STRUCT *psTaskInfo
        );

BOOLEAN OSAL_bTaskGetId ( OSAL_TASK_ID *ptTaskId );

OSAL_RETURN_CODE_ENUM OSAL_eTaskList ( void );

#if OSAL_DEBUG == 1

BOOLEAN OSALT_bPrintTask ( void *pvData, void *pvArg );
void OSALT_vTaskSetDebug (
    OSAL_OBJECT_HDL hTask,
    OSAL_TASK_DEBUG_STRUCT *psDebug
        );

#endif /* OSAL_DEBUG == 1 */

BOOLEAN OSALT_bTaskDebugIsEnabled ( void );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_TASK_H_
