/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_STDIO_H_
#define OSAL_STDIO_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define STDIO_FILE_CLUSTER_SIZE  (4 * 1024)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_FILE_STRUCT *OSAL_psFopen(const char *pcFileName, const char *pcMode);
int OSAL_iFclose(OSAL_FILE_STRUCT *psFile);
size_t OSAL_tFread(void *pvDst, size_t tSize, size_t tNumObj,
                  OSAL_FILE_STRUCT *psFile);
size_t OSAL_tFwrite(const void *pvSrc, size_t tSize, size_t tNumObj,
                   OSAL_FILE_STRUCT *psFile);
long OSAL_lFtell(OSAL_FILE_STRUCT *psFile);
int OSAL_iIoctl(OSAL_FILE_STRUCT *psFile, int iCmd, ...);
int OSAL_iFseek(OSAL_FILE_STRUCT *psFile, long lOffset, int iMode);
int OSAL_iRemove(const char *pcFileName);
int OSAL_iRename(const char *pcOldFileName, const char *pcNewFileName);
int OSAL_iCopyFile(const char *pcSrcFileName, const char *pcDstFileName, BOOLEAN bForce);
int OSAL_iFflush(OSAL_FILE_STRUCT *psFile);
int OSAL_iFerror(OSAL_FILE_STRUCT *psFile);
int OSAL_iFeof(OSAL_FILE_STRUCT *psFile);
void OSAL_vClearerr(OSAL_FILE_STRUCT *psFile);

int OSAL_iFgetc(OSAL_FILE_STRUCT *psFile);
char *OSAL_pcFgets(char *pcDest, int iNum, OSAL_FILE_STRUCT *psFile);
int OSAL_iFputc(int iChar, OSAL_FILE_STRUCT *psFile);
int OSAL_iFputs(const char *pcSrc, OSAL_FILE_STRUCT *psFile);
int OSAL_iFPrintf(OSAL_FILE_STRUCT *psFile, const char *pcFormat, ...);

void OSAL_vDump( OSAL_FILE_STRUCT *psFile, UN16 *pun16Row,
                const void *pvData, UN32 un32Length );

#ifndef OSAL_USE_NATIVE_STDIO

int OSAL_iPrintf(const char *pcFormat, ...);
int OSAL_iPutchar(int iChar);
int OSAL_iPuts(const char *pcSrc);
int OSAL_iGetchar(void);
char *OSAL_pcGets(char *pcDest);

#endif

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_STDIO_H_
