/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio Inc.                      */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio Inc.              */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
*
*	GLOBAL HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_RB_TREE_H_
#define OSAL_RB_TREE_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// RB Tree Entry
typedef struct osal_rbtree_entry_struct *OSAL_RB_TREE_ENTRY;
#define OSAL_INVALID_RB_TREE_ENTRY ((OSAL_RB_TREE_ENTRY)NULL)

// RB Tree
typedef struct osal_rbtree_struct *OSAL_RB_TREE_HDL;
#define OSAL_INVALID_RB_TREE_HDL ((OSAL_RB_TREE_HDL)NULL)

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeCreate(
    OSAL_RB_TREE_HDL *phRBTree,
    const char *pacName,
    OSAL_OBJECT_HDL hLL,
    OSAL_LL_COMPARE_HANDLER n16CompareFunction
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeDelete(
    OSAL_RB_TREE_HDL hRBTree
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeAdd (
    OSAL_RB_TREE_HDL hRBTree,
    OSAL_RB_TREE_ENTRY *phEntry,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeReplace (
    OSAL_RB_TREE_HDL hRBTree,
    OSAL_RB_TREE_ENTRY hEntry,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeRemove(
    OSAL_RB_TREE_ENTRY hEntry
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeSearch(
    OSAL_RB_TREE_HDL hRBTree,
    OSAL_RB_TREE_ENTRY *phEntry,
    OSAL_LL_COMPARE_HANDLER n16CompareFunction,
    void *pvData
        );

OSAL_RB_TREE_ENTRY OSAL_hRBTreeFirst(
    OSAL_RB_TREE_HDL hRBTree,
    void **ppvData
        );

OSAL_RB_TREE_ENTRY OSAL_hRBTreeLast(
    OSAL_RB_TREE_HDL hRBTree,
    void **ppvData
        );

OSAL_RB_TREE_ENTRY OSAL_hRBTreeNext(
    OSAL_RB_TREE_ENTRY hEntry,
    void **ppvData
        );

OSAL_RB_TREE_ENTRY OSAL_hRBTreePrev(
    OSAL_RB_TREE_ENTRY hEntry,
    void **ppvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeRemoveAll(
    OSAL_RB_TREE_HDL hRBTree,
    OSAL_LL_RELEASE_HANDLER vReleaseFunction
        );

void *OSAL_pvRBTreeThis(
    OSAL_RB_TREE_ENTRY hEntry
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeIterate (
    OSAL_RB_TREE_HDL hRBTree,
    OSAL_LL_ITERATOR_HANDLER tbIterator,
    void *pvArg
        );

OSAL_RETURN_CODE_ENUM OSAL_eRBTreeItems (
    OSAL_RB_TREE_HDL hRBTree,
    UN32* pun32Items
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif /* OSAL_RB_TREE_H_ */
