/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*	GLOBAL HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_QUEUE_H_
#define OSAL_QUEUE_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

/* Queues */
typedef struct osal_queue_private_info_struct
{
    // Mutex to guard this information
    OSAL_OBJECT_HDL hMutex;

    // Message management elements. Used to manage allocations and
    // queuing of messages.
    // List of all free-to-use messages
    OSAL_OBJECT_HDL hFreeMessageList;
    // List of all allocated messages
    OSAL_OBJECT_HDL hAllocatedMessageList;
    // List of all allocated and queued messages
    OSAL_OBJECT_HDL hQueuedMessageList;
    // Msg allocation control
    OSAL_OBJECT_HDL hMessageAllocSem;
    // Msg pend control
    OSAL_OBJECT_HDL hMessagePendSem;

    // Exclusive access methods
    BOOLEAN (*bEnterExclusiveAccess)(OSAL_OBJECT_HDL hMutex);
    void (*vExitExclusiveAccess)(OSAL_OBJECT_HDL hMutex);

    // Public Queue info structure
    OSAL_QUEUE_INFO_STRUCT sPublicInfo;

} OSAL_QUEUE_PRIVATE_INFO_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_RETURN_CODE_ENUM OSAL_eQueueCreate (
    OSAL_OBJECT_HDL *phQueueObj,
    const char *pacName,
    UN32 un32QueueDepth, UN32 un32MessageSize,
    UN32 un32Options
        );

OSAL_RETURN_CODE_ENUM OSAL_eQueueDelete (
    OSAL_OBJECT_HDL hQueueObj
        );

OSAL_RETURN_CODE_ENUM OSAL_eQueueGet (
    OSAL_OBJECT_HDL hQueueObj,
    void **ppvMessage, UN32 *pun32MessageSize,
    N32 n32Timeout
        );

OSAL_RETURN_CODE_ENUM OSAL_eQueuePut (
    const void *pvMessage,
    UN32 un32MessageSize
        );

OSAL_OBJECT_HDL OSAL_hQueueGetHandleByName (
    const char *pacName
        );

OSAL_RETURN_CODE_ENUM OSAL_eQueueGetInfo (
    OSAL_OBJECT_HDL hQueueObj,
    OSAL_QUEUE_INFO_STRUCT *psQueueInfo
        );

OSAL_RETURN_CODE_ENUM OSAL_eQueueList ( void );

#if (OSAL_DEBUG == 1)

BOOLEAN OSALQ_bPrintQueue ( void *pvData, void *pvArg );

#endif /*(OSAL_DEBUG == 1) */

OSAL_RETURN_CODE_ENUM OSAL_eMessageAllocate (
    OSAL_OBJECT_HDL hQueueObj,
    void **ppvMessage,
    UN32 un32Flags
        );

OSAL_RETURN_CODE_ENUM OSAL_eMessageFree (
    const void *pvMessage
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_QUEUE_H_
