/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_LL_H_
#define OSAL_LL_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal.h"
#include "osal_rb_tree.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct osal_ll_info_struct
{
    // The object that created this list (a task)
    OSAL_OBJECT_HDL hCreatorObj;

    // Options which may be associated with this list
    UN32 un32Options;

    union
    {
        struct
        {
            // A handle to the 'first' entry in the list
            OSAL_LINKED_LIST_ENTRY hTopOfListEntry;

            // A handle to the 'last' entry in the list
            OSAL_LINKED_LIST_ENTRY hBottomOfListEntry;

            // A count of the number of elements in the list
            UN32 un32Count;

            // A function which compares two objects of the same type
            // and returns a value indicating if an object is greater-than,
            // less-than, or equal-to another object.
            OSAL_LL_COMPARE_HANDLER tn16CompareFunction;
        } sList;

        // RB Tree
        OSAL_RB_TREE_HDL hRBTree;

    } uList;

} OSAL_LL_INFO_STRUCT;

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListCreate(
    OSAL_OBJECT_HDL *phLL,
    const char *pacName,
    OSAL_LL_COMPARE_HANDLER tn16CompareFunction,
    UN32 un32Options
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListDelete(
    OSAL_OBJECT_HDL hLL
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListAdd (
    OSAL_OBJECT_HDL hLL,
    OSAL_LINKED_LIST_ENTRY *phEntry,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListReplaceEntry(
    OSAL_OBJECT_HDL hLL,
    OSAL_LINKED_LIST_ENTRY hEntry,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListAddBeforeEntry(
    OSAL_OBJECT_HDL hLL,
    OSAL_LINKED_LIST_ENTRY *phEntry,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListAddAfterEntry(
    OSAL_OBJECT_HDL hLL,
    OSAL_LINKED_LIST_ENTRY *phEntry,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListRemove(
    OSAL_LINKED_LIST_ENTRY hEntry
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListSearch(
    OSAL_OBJECT_HDL hLL,
    OSAL_LINKED_LIST_ENTRY *phEntry,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListLinearSearch(
    OSAL_OBJECT_HDL hLL,
    OSAL_LINKED_LIST_ENTRY *phEntry,
    OSAL_LL_COMPARE_HANDLER tn16CompareFunction,
    void *pvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListSort(
    OSAL_OBJECT_HDL hLL,
    OSAL_LL_COMPARE_HANDLER tn16Compare
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListRemoveAll(
    OSAL_OBJECT_HDL hLL,
    OSAL_LL_RELEASE_HANDLER tvReleaseFunction
        );

void *OSAL_pvLinkedListThis(
    OSAL_LINKED_LIST_ENTRY hEntry
        );

OSAL_LINKED_LIST_ENTRY OSAL_hLinkedListFirst(
    OSAL_OBJECT_HDL hLL,
    void **ppvData
        );

OSAL_LINKED_LIST_ENTRY OSAL_hLinkedListLast(
    OSAL_OBJECT_HDL hLL,
    void **ppvData
        );

OSAL_LINKED_LIST_ENTRY OSAL_hLinkedListNext(
    OSAL_LINKED_LIST_ENTRY hCurrent,
    void **ppvData
        );

OSAL_LINKED_LIST_ENTRY OSAL_hLinkedListPrev(
    OSAL_LINKED_LIST_ENTRY hCurrent,
    void **ppvData
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListIterate (
    OSAL_OBJECT_HDL hLL,
    OSAL_LL_ITERATOR_HANDLER tvIterator,
    void *pvArg
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListItems (
    OSAL_OBJECT_HDL hLL,
    UN32 *pun32Items
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListProtect (
    OSAL_OBJECT_HDL hLL
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListUnprotect (
    OSAL_OBJECT_HDL hLL
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListLock (
    OSAL_OBJECT_HDL hLL
        );

OSAL_RETURN_CODE_ENUM OSAL_eLinkedListUnlock (
    OSAL_OBJECT_HDL hLL
        );

void *OSAL_pvLinkedListMemoryAllocate(
    const char *pacName,
    size_t tSize,
    BOOLEAN bZeroInitialize
        );

void OSAL_vLinkedListMemoryFree(
      void *pvObject
          );

size_t OSAL_tLinkedListEntrySize(
     void
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_LL_H_
