/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_GENERAL_H_
#define OSAL_GENERAL_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
OSAL_CONFIG_INFO_MASK OSAL_tConfigInfo( void );

BOOLEAN OSAL_bStart (
    const OSAL_START_HANDLER_STRUCT *psStartHandlers
        );

BOOLEAN OSAL_bSleep ( void );

BOOLEAN OSAL_bWakeup ( void );

BOOLEAN OSAL_bShutdown ( void );

void OSAL_vEnterCriticalSection ( void );

void OSAL_vExitCriticalSection ( void );

OSAL_RETURN_CODE_ENUM OSAL_eEnterTaskSafeSection ( void );

OSAL_RETURN_CODE_ENUM OSAL_eExitTaskSafeSection ( void );

OSAL_RETURN_CODE_ENUM OSAL_eGetUtilizationCPU(
    UN8 *pun8Current,
    UN8 *pun8Max,
    UN8 *pun8Min
        );

void OSAL_vResetUtilizationCPU ( void );

const char *OSAL_pacGetReturnCodeName (
    OSAL_RETURN_CODE_ENUM eReturnCode
        );

const char *OSAL_pacGetVersion (
    UN8 *pun8MajorVersion,
    UN8 *pun8MinorVersion,
    UN8 *pun8SubVersion
    );

const char *OSAL_pacGetObjectName (
    OSAL_OBJECT_HDL hObj
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_GENERAL_H_
