/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_FS_H_
#define OSAL_FS_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN OSAL_bFileSystemStart ( void );
BOOLEAN OSAL_bFileSystemStop ( void );
void OSAL_vFileSystemVolumes ( FILE *psFile );
BOOLEAN OSAL_bFileSystemVolumeInfo ( FILE *psFile, const char *pcVolName );
BOOLEAN OSAL_bFileSystemDirectory ( FILE *psFile, const char *pcPathName );
BOOLEAN OSAL_bFileSystemMakeDir ( const char *pcDirName );
BOOLEAN OSAL_bFileSystemRemoveDir ( const char *pcDirName );
OSAL_RETURN_CODE_ENUM OSAL_eFileSystemGetDirItems (
    OSAL_OBJECT_HDL *phDirItems, const char *pcPathName,
    OSAL_FS_FILE_QUALIFIER bFileQualifierFunc, void *pvQualiferArg);
OSAL_RETURN_CODE_ENUM OSAL_eFileSystemReleaseDirItems (OSAL_OBJECT_HDL hDirItems);
BOOLEAN OSAL_bFileSystemTruncateFile ( FILE *psFile, size_t tNewSize );
BOOLEAN OSAL_bFileSystemGetFileSize ( FILE *psFile, size_t *ptFileSize );
BOOLEAN OSAL_bFileSystemGetFileAttributes ( const char *pcPath,
										    UN8 *pun8FileAttributes );
BOOLEAN OSAL_bFileSystemSetFileAttributes ( const char *pcPath,
										    UN8 un8FileAttributes );
BOOLEAN OSAL_bFileSystemSetTempPath ( const char *pacTempPath );
size_t OSAL_tFileSystemGetTempPath ( size_t tDstSize,
                                     char *pacDst );
BOOLEAN OSAL_bFileSystemSyncFile ( FILE *psFile );
BOOLEAN OSAL_bFileSystemUnconditionalFileUnlink ( const char *pcPath );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_FS_H_
