/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_DEBUG_H_
#define OSAL_DEBUG_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef enum osal_debug_state_enum
{
    OSAL_DEBUG_EXIT,
    OSAL_DEBUG_MAIN,
#if OSAL_TEST == 1
    OSAL_DEBUG_TEST,
#endif /* OSAL_TEST == 1 */
#if OSAL_FILE_SYSTEM == 1
    OSAL_DEBUG_FS,
#endif /* OSAL_FILE_SYSTEM == 1 */
#if OSAL_FIXED_MATH == 1
    OSAL_DEBUG_FIXED,
#endif /* OSAL_FIXED_MATH == 1 */

} OSAL_DEBUG_STATE_ENUM;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

void OSALD_vDebugMenuHandler( char *pcCmdLine, const void *pvArg );
#if OSAL_DEBUG == 1
void OSALD_vPrintTime(UN32 un32Seconds, UN16 un16Msecs);
#endif

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_DEBUG_H_
