/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_BUF_H_
#define OSAL_BUF_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

/**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct osal_block_pool_private_info_struct
{
    OSAL_OBJECT_HDL hBufferQueue;
    OSAL_OBJECT_HDL hBlockQueue;

    // Exclusive access methods
    BOOLEAN (*bEnterExclusiveAccess)(OSAL_OBJECT_HDL hMutex);
    void (*vExitExclusiveAccess)(OSAL_OBJECT_HDL hMutex);

    // Mutex to guard this public information
    OSAL_OBJECT_HDL hMutex;

    // Public Block Pool info structure
    OSAL_BLOCK_POOL_INFO_STRUCT sPublicInfo;

} OSAL_BLOCK_POOL_PRIVATE_INFO_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_RETURN_CODE_ENUM OSAL_eBlockPoolCreate (
    OSAL_OBJECT_HDL *phBlockPool,
    const char *pacName,
    UN16 un16BlockSize,
    UN16 un16NumBlocks,
    UN32 un32Options
        );

OSAL_RETURN_CODE_ENUM OSAL_eBlockPoolDelete (
    OSAL_OBJECT_HDL hBlockPool
        );

OSAL_BUFFER_HDL OSAL_hBufferAllocate (
    OSAL_OBJECT_HDL hBlockPoolObj,
    BOOLEAN bBlockingRead,
    BOOLEAN bBlockingWrite,
    UN32 un32Options
        );

OSAL_RETURN_CODE_ENUM OSAL_eBufferFree (
    OSAL_BUFFER_HDL hBuffer
        );

size_t OSAL_tBufferGetSize (
    OSAL_BUFFER_HDL hBuffer
        );

size_t OSAL_tBufferGetSizeInBits (
    OSAL_BUFFER_HDL hBuffer
        );

OSAL_RETURN_CODE_ENUM OSAL_eBufferBlocksIterate (
    OSAL_BUFFER_HDL hBuffer,
    OSAL_BUFFER_ITERATOR_HANDLER teIterator,
    void *pvArg
        );

size_t OSAL_tBufferPeek (
    OSAL_BUFFER_HDL hBuffer,
    void *pvDst,
    size_t tSize,
    size_t tOffset
        );

size_t OSAL_tBufferPeekBits (
    OSAL_BUFFER_HDL hBuffer,
    void *pvDst,
    size_t tDstBitOffset,
    N32 n32Bits,
    size_t tBufferOffsetBits
        );

size_t OSAL_tBufferReadHead (
    OSAL_BUFFER_HDL hBuffer,
    void *pvDst,
    size_t tSize,
    ...
        );

size_t OSAL_tBufferReadHeadBits(
    OSAL_BUFFER_HDL hBuffer,
    void *pvDst,
    size_t tDstBitOffset,
    N32 n32Bits,
    ...
        );

size_t OSAL_tBufferReadTail (
    OSAL_BUFFER_HDL hBuffer,
    void *pvDst,
    size_t tSize,
    ...
        );

size_t OSAL_tBufferSeekHead (
    OSAL_BUFFER_HDL hBuffer,
    size_t tSize
        );

size_t OSAL_tBufferSeekHeadBits (
    OSAL_BUFFER_HDL hBuffer,
    size_t tSizeBits
        );

size_t OSAL_tBufferSeekTail (
    OSAL_BUFFER_HDL hBuffer,
    size_t tSize
        );

OSAL_BUFFER_BLOCK_HDL OSAL_hBufferReadBlock (
    OSAL_BUFFER_HDL hBuffer,
    UN8 **ppun8Data,
    size_t *ptSize,
    ...
        );

OSAL_RETURN_CODE_ENUM OSAL_eBufferReleaseBlock (
    OSAL_BUFFER_BLOCK_HDL hBufferBlock
        );

OSAL_RETURN_CODE_ENUM OSAL_eBufferAppend (
    OSAL_BUFFER_HDL hDstBuffer,
    OSAL_BUFFER_HDL hBufferDataToAppend
        );

OSAL_RETURN_CODE_ENUM OSAL_eBufferWriteToFile (
    OSAL_BUFFER_HDL hBuffer,
    BOOLEAN bConsumeData,
    FILE *psFile
        );

size_t OSAL_tBufferWriteHead (
    OSAL_BUFFER_HDL hBuffer,
    const void *pvSrc,
    size_t tSize,
    ...
        );

size_t OSAL_tBufferWriteTail (
    OSAL_BUFFER_HDL hBuffer,
    const void *pvSrc,
    size_t tSize,
    ...
        );

size_t OSAL_tBufferWriteTailBits (
    OSAL_BUFFER_HDL hBuffer,
    const void *pvSrc,
    size_t tSrcBitOffset,
    N32 n32Bits,
    ...
        );
OSAL_BUFFER_BLOCK_HDL OSAL_hBufferGetBlock (
    OSAL_BUFFER_HDL hBuffer,
    UN8 **ppun8Data,
    size_t *ptSize,
    ...
        );

OSAL_RETURN_CODE_ENUM OSAL_eBufferWriteBlock (
    OSAL_BUFFER_BLOCK_HDL hBufferBlock,
    size_t tSize
        );

OSAL_OBJECT_HDL OSAL_hBlockPoolGetHandleByName (
    const char *pacName
        );

OSAL_RETURN_CODE_ENUM OSAL_eBlockPoolGetInfo (
    OSAL_OBJECT_HDL hBlockPoolObj,
    OSAL_BLOCK_POOL_INFO_STRUCT *psBlockPoolInfo
        );

OSAL_RETURN_CODE_ENUM OSAL_eBlockPoolList ( void );

size_t OSAL_tBufferReadString (
    OSAL_BUFFER_HDL hBuffer,
    char *pacString,
    size_t tSize
        );

BOOLEAN OSAL_bBufferReadBitsToUN16(
    OSAL_BUFFER_HDL hBuffer,
    UN16 *pun16Dest,
    size_t tBits
        );

BOOLEAN OSAL_bBufferReadBitsToN16(
    OSAL_BUFFER_HDL hBuffer,
    N16 *pn16Dest,
    size_t tBits
        );

BOOLEAN OSAL_bBufferReadBitsToUN32(
    OSAL_BUFFER_HDL hBuffer,
    UN32 *pun32Dest,
    size_t tBits
        );

BOOLEAN OSAL_bBufferReadBitsToN32(
    OSAL_BUFFER_HDL hBuffer,
    N32 *pn32Dest,
    size_t tBits
        );

BOOLEAN OSAL_bBufferReadBitsToUN64(
    OSAL_BUFFER_HDL hBuffer,
    UN64 *pun64Dest,
    size_t tBits
        );

BOOLEAN OSAL_bBufferReadBitsToN64(
    OSAL_BUFFER_HDL hBuffer,
    N64 *pn64Dest,
    size_t tBits
        );

BOOLEAN OSAL_bBufferPeekBitsToUN16(
    OSAL_BUFFER_HDL hBuffer,
    UN16 *pun16Dest,
    size_t tBits,
    size_t tBufferOffsetBits
        );

BOOLEAN OSAL_bBufferPeekBitsToN16(
    OSAL_BUFFER_HDL hBuffer,
    N16 *pn16Dest,
    size_t tBits,
    size_t tBufferOffsetBits
        );

BOOLEAN OSAL_bBufferPeekBitsToUN32(
    OSAL_BUFFER_HDL hBuffer,
    UN32 *pun32Dest,
    size_t tBits,
    size_t tBufferOffsetBits
        );

BOOLEAN OSAL_bBufferPeekBitsToN32(
    OSAL_BUFFER_HDL hBuffer,
    N32 *pn32Dest,
    size_t tBits,
    size_t tBufferOffsetBits
        );

BOOLEAN OSAL_bBufferPeekBitsToUN64(
    OSAL_BUFFER_HDL hBuffer,
    UN64 *pun64Dest,
    size_t tBits,
    size_t tBufferOffsetBits
        );

BOOLEAN OSAL_bBufferPeekBitsToN64(
    OSAL_BUFFER_HDL hBuffer,
    N64 *pn64Dest,
    size_t tBits,
    size_t tBufferOffsetBits
        );


  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_BUF_H_
