/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_STDIO_H_
#define _OSAL_STDIO_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"

#include "osal.h"
#include "osal_devices.h"

  /***************/
 /** CONSTANTS **/
/***************/

#define STDIO_DUMP_WIDTH (16)

#if BUFSIZ < 1024
#define _BUFSIZ 1024
#else
#define _BUFSIZ BUFSIZ
#endif

#define OSAL_FS_REMOVE_ATTEMPTS (10)
#define OSAL_FS_REMOVE_DELAY    (10)

  /**************/
 /** TYPEDEFS **/
/**************/

  /***************/
 /** VARIABLES **/
/***************/

BOOLEAN _PRINTF_ENABLED = TRUE;

// File-System Implementations (if any)
extern const OSAL_FILE_INTERFACE_STRUCT GsFSIntf;

// Device Framework Implementations
extern const OSAL_FILE_INTERFACE_STRUCT GsDeviceIntf;

// File pointer for standard input stream.
// Automatically opened when program execution begins.
OSAL_FILE_STRUCT GsStdin = {&GsDeviceIntf, NULL, 0, NULL}; // stdin

// File pointer for standard output stream.
// Automatically opened when program execution begins.
OSAL_FILE_STRUCT GsStdout = {&GsDeviceIntf, NULL, 0, NULL}; // stdout

// File pointer for standard error stream.
// Automatically opened when program execution begins.
OSAL_FILE_STRUCT GsStderr = {&GsDeviceIntf, NULL, 0, NULL}; // stderr

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static int _outputf( OSAL_FILE_STRUCT *psFile, const char *pcFormat,
                     va_list *ptArgList );

static __INLINE__ BOOLEAN bVerifyFileMode (const char *pcMode);

#if OSAL_DEBUG == 1
static __INLINE__ int iTranslateChar( char cChar, char *pacChars );
#endif

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_STDIO_H_
