/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio Inc.                      */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio Inc.              */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
*
*    LOCAL HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_RB_TREE_H_
#define _OSAL_RB_TREE_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct osal_rb_tree_info_struct
{
    // RB-Tree owner list
    OSAL_OBJECT_HDL hLL;

    // A name provided for this rb tree
    char acName[OSAL_MAX_OBJECT_NAME_LENGTH_WITH_NULL];

    // A function which compares two objects of the same type
    // and returns a value indicating if an object is greater-than,
    // less-than, or equal-to another object.
    OSAL_LL_COMPARE_HANDLER n16CompareFunction;

    // RB tree root
    struct osal_rb_tree_node_struct *psRoot;

    // A count of the number of elements in the tree
    UN32 un32Count;
} OSAL_RB_TREE_INFO_STRUCT;

typedef enum osal_rb_tree_node_type_enum
{
    OSAL_RB_TREE_NODE_RED,
    OSAL_RB_TREE_NODE_BLACK
} OSAL_RB_TREE_NODE_TYPE_ENUM;

typedef struct osal_rb_tree_node_struct
{
    // Reference to owner (Linked List)
    // This field must be the first since this reference is used
    // to get list object from entry handle. In some cases
    // list user provides reference to entry and we should have some
    // reference to owner list to process request correctly based on
    // LL representation.
    OSAL_OBJECT_HDL hLL;

    // Tree
    OSAL_RB_TREE_INFO_STRUCT *psRBTree;

    // Parent node address
    struct osal_rb_tree_node_struct *psParent;

    // Right child node address
    struct osal_rb_tree_node_struct *psRight;

    // Left child node address
    struct osal_rb_tree_node_struct *psLeft;

    // Node color
    OSAL_RB_TREE_NODE_TYPE_ENUM eColor;

    // Node data reference
    void *pvData;
} OSAL_RB_TREE_NODE_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/
/* all leafs are sentinels */
#define OSAL_RB_TREE_NODE_NULL (&sSentinel)
static OSAL_RB_TREE_NODE_STRUCT sSentinel = {
    /*.hLL = */       OSAL_INVALID_OBJECT_HDL,
    /*.psRBTree = */  NULL,
    /*.psParent = */  OSAL_RB_TREE_NODE_NULL,
    /*.psLeft = */    OSAL_RB_TREE_NODE_NULL,
    /*.psRight = */   OSAL_RB_TREE_NODE_NULL,
    /*.eColor = */    OSAL_RB_TREE_NODE_BLACK,
    /*.pvData = */    NULL
};

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static N16 n16RBTreeCompareObjects(
    void *pvData1,
    void *pvData2
        );

static OSAL_RETURN_CODE_ENUM eRBTreeInsertNode(
    OSAL_RB_TREE_INFO_STRUCT *psTree,
    OSAL_RB_TREE_NODE_STRUCT **ppsNode
        );

static void vRBTreeDeleteFixup (
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    OSAL_RB_TREE_NODE_STRUCT *psNodeX
        );

static void vRBTreeDetachNode(
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    OSAL_RB_TREE_NODE_STRUCT *psNodeZ
        );

static void vRBTreeDestroyNode(
    OSAL_RB_TREE_NODE_STRUCT *psNode
        );

static void vRBTreeDeleteFixup (
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    OSAL_RB_TREE_NODE_STRUCT *psNodeX
        );

static void vRBTreeInsertFixup(
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    OSAL_RB_TREE_NODE_STRUCT *psNodeX
        );

static void vRBTreeRotateLeft(
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    OSAL_RB_TREE_NODE_STRUCT *psNodeX
        );

static void vRBTreeRotateRight(
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    OSAL_RB_TREE_NODE_STRUCT *psNodeX
        );

static OSAL_RB_TREE_NODE_STRUCT *psRBTreeFirst(
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    void **ppvData
        );

static OSAL_RB_TREE_NODE_STRUCT *psRBTreeLast(
    OSAL_RB_TREE_INFO_STRUCT *psRBTree,
    void **ppvData
        );

static OSAL_RB_TREE_NODE_STRUCT *psRBTreeNext(
    OSAL_RB_TREE_NODE_STRUCT *psNode,
    void **ppvData
        );

static OSAL_RB_TREE_NODE_STRUCT *psRBTreePrev(
    OSAL_RB_TREE_NODE_STRUCT *psNode,
    void **ppvData
        );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _OSAL_RB_TREE_H_ */
