/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*	LOCAL HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_QUEUE_H_
#define _OSAL_QUEUE_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>
#include "standard.h"

#include "osal_queue.h"

  /***************/
 /** CONSTANTS **/
/***************/

/* Note: It is critical that these flags are the very specific bitmask values
    below. The reason being that these bitmasks when combined create a
    "magnitude of priority" which makes comparison nothing more than a
    mere subtraction instead of comparing combinations of bits. Modify
    (if necessary with extreme caution).

    Order in the list is;

    OSAL_MSG_FLAG_URGENT|OSAL_MSG_FLAG_QUEUED|OSAL_MSG_FLAG_ALLOCATED = 0x31
    OSAL_MSG_FLAG_QUEUED|OSAL_MSG_FLAG_ALLOCATED = 0x30
    OSAL_MSG_FLAG_ALLOCATED = 0x10
    OSAL_MSG_FLAG_NONE (available) = 0x00

*/
#define OSAL_MSG_FLAG_URGENT      (0x01)
#define OSAL_MSG_FLAG_QUEUED      (0x20)
#define OSAL_MSG_FLAG_ALLOCATED   (0x10)
#define OSAL_MSG_FLAG_NONE        (0x00)
#define OSAL_MSG_FLAG_DEFERRED    (0x02)

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct osal_queue_msg_struct
{
    // A handle to the OSAL-queue for which this
    // message belongs. Use for back-referencing the queue.
    OSAL_OBJECT_HDL hQueueObj;

    // The size of the payload portion of this message
    // This is mainly used for variable sized messages. This is
    // the size of the caller's payload when the message was posted.
    size_t tSize;

    // Message block control flags
    UN8 un8Flags;

    // This message's entry handle in the linked list
    OSAL_LINKED_LIST_ENTRY hThisEntry;

    /* Payload Data  (allocated when queue is created) */

} OSAL_QUEUE_MSG_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/
static const OSAL_QUEUE_MSG_STRUCT GsQueueMsgDefault = {
    /* hQueueObj = */ OSAL_INVALID_OBJECT_HDL,
    /* tSize = */ 0,
    /* un8Flags = */ OSAL_MSG_FLAG_NONE,
    /* hThisEntry = */ OSAL_INVALID_LINKED_LIST_ENTRY
};

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static OSAL_RETURN_CODE_ENUM eMoveMsgToList (
    OSAL_QUEUE_MSG_STRUCT *psQueueMsg,
    OSAL_OBJECT_HDL hList,
    BOOLEAN bUsePriotity
        );

static void vInitializeMessageHeader(
    void *pvData
        );

static BOOLEAN bEnterExclusiveAccessTaskOnly(
    OSAL_OBJECT_HDL hMutex
        );

static void vExitExclusiveAccessTaskOnly(
    OSAL_OBJECT_HDL hMutex
        );

static BOOLEAN bEnterExclusiveAccessInterrupt(
    OSAL_OBJECT_HDL hMutex
        );

static void vExitExclusiveAccessInterrupt(
    OSAL_OBJECT_HDL hMutex
        );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_QUEUE_H_
