/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_MONITOR_H_
#define _OSAL_MONITOR_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>
#include "standard.h"

#include "osal_monitor.h"

  /***************/
 /** CONSTANTS **/
/***************/

#define OSALM_TASK_OPTIONS				(OSAL_TASK_OPTION_NONE)
#define OSALM_TASK_STACK_SIZE  		    (1536)

#define OSALM_REPORTING_RESOLUTION_MSEC (1000)
#define OSALM_MAX_STACK_USAGE           (70) // Percent
#define OSALM_MAX_CPU_UTILIZATION       (70) // Percent
#define OSALM_MAX_MEMORY_ALLOCATION     (70) // Percent

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct osalm_task_control_struct
{
    // Install Complete Semaphore
    OSAL_OBJECT_HDL hInstallSemaphore;

    // My Task Handle
    OSAL_OBJECT_HDL hMyTaskObj;

    // Task Monitor Linked List Handle
    OSAL_OBJECT_HDL hTaskList;

    // Task Monitor Error Code
    OSAL_RETURN_CODE_ENUM eErrorCode;

    // Task currently being checked
    OSAL_OBJECT_HDL hTaskObj;

    // Task info of current task being checked
    OSAL_TASK_INFO_STRUCT sTaskInfo;

    // System level parameters checked
    UN32 un32ActualBytesUsed;
    UN32 un32ActualBytesThreshold;
    UN8 un8MaxUtilization;

    // CPU Utilization Warning Toggle
    BOOLEAN bCpuUtilizationWarning;

    // OSAL Monitor Handlers
    const OSAL_MONITOR_HANDLER_STRUCT *psMonitorHandlers;

    // Device Driver Error Code
    OSAL_RETURN_CODE_ENUM eSystemErrorCode;

} OSALM_TASK_CONTROL_STRUCT;

typedef struct osalm_task_registration_struct
{
    OSAL_OBJECT_HDL hTaskObj;

} OSALM_TASK_REGISTRATION_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

static OSALM_TASK_CONTROL_STRUCT gsMonitorTaskControl;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static N32 OSALM_n32Task ( void *pvArg );
static BOOLEAN OSALM_bTaskInitialize( void );
static void OSALM_vTaskUninitialize( void );
static N16 OSALM_n16CompareTask( void *pvObj1, void *pvObj2 );
static BOOLEAN OSALM_bProcessTasks ( void *pvData, void *pvArg );
static OSAL_RETURN_CODE_ENUM OSALM_eCheckTask ( OSAL_OBJECT_HDL hTaskObj );
static OSAL_RETURN_CODE_ENUM OSALM_eCheckSystem ( void );
static void OSALM_vTaskMonitorViolationHandler ( void );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_MONITOR_H_
