/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*    LOCAL HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_LL_H_
#define _OSAL_LL_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/
#define OSAL_LL_ELEMENT_STRUCT_SIZE sizeof(OSAL_LL_ELEMENT_STRUCT)

// This is a value defined the stack used by the sort algorithm and
// should be calculated as (log2(N) + 1) where the N is number of items
// available for sorting. In our case there is an assumption the LL
// won't have more that 2^32 element for OSAL users.
#define OSAL_LL_ELEMENT_SORT_STACK_SIZE (32)

  /**************/
 /** TYPEDEFS **/
/**************/
typedef enum osal_ll_insert_enum
{
    OSAL_LL_INSERT_BEFORE,
    OSAL_LL_INSERT_AFTER,
    OSAL_LL_INSERT_HERE,
    OSAL_LL_INSERT_MAX,

} OSAL_LL_INSERT_ENUM;

typedef struct osal_ll_element_struct
{
    OSAL_OBJECT_HDL hLL;

    void *pvData;

    struct osal_ll_element_struct *psNext;
    struct osal_ll_element_struct *psPrev;

} OSAL_LL_ELEMENT_STRUCT;

typedef struct osal_ll_element_sort_stack_item_struct
{
    UN32 un32Level;
    OSAL_LL_ELEMENT_STRUCT *psEntry;
} OSAL_LL_ELEMENT_SORT_STACK_ITEM_STRUCT;

  /************/
 /** MACROS **/
/************/
#define INSERT_ENTRY_AFTER(ppsWhat, psWhere) \
    (*ppsWhat)->psNext = psWhere->psNext; \
    (*ppsWhat)->psPrev = psWhere; \
    if((*ppsWhat)->psNext != NULL) \
    { \
        (*ppsWhat)->psNext->psPrev = (*ppsWhat); \
    } \
    psWhere->psNext = (*ppsWhat);

#define INSERT_ENTRY_BEFORE(ppsWhat, psWhere) \
    (*ppsWhat)->psNext = psWhere; \
    (*ppsWhat)->psPrev = psWhere->psPrev; \
    if((*ppsWhat)->psPrev != NULL) \
    { \
        (*ppsWhat)->psPrev->psNext = (*ppsWhat); \
    } \
    psWhere->psPrev = (*ppsWhat);

  /****************/
 /** PROTOTYPES **/
/****************/

static N16 OSALLL_n16ComparePayload(
    void *pvObj1,
    void *pvObj2
        );

static OSAL_RETURN_CODE_ENUM OSALLL_eInsert(
    OSAL_OBJECT_HDL hLL,
    OSAL_LL_INFO_STRUCT *psInfo,
    OSAL_LL_INSERT_ENUM eInsertType,
    OSAL_LL_ELEMENT_STRUCT *psPosition,
    OSAL_LL_ELEMENT_STRUCT **ppsNewLink,
    void *pvData,
    BOOLEAN bLinear
        );

static OSAL_RETURN_CODE_ENUM OSALLL_eSortedInsert(
    OSAL_OBJECT_HDL hLL,
    OSAL_LL_INFO_STRUCT *psInfo,
    OSAL_LL_ELEMENT_STRUCT *psCurrent,
    OSAL_LL_ELEMENT_STRUCT **ppsNewLink,
    void *pvData,
    OSAL_LL_COMPARE_HANDLER vCompare,
    BOOLEAN bLinear
        );

static void OSALLL_vRemove(
    OSAL_LL_ELEMENT_STRUCT *psLink
        );

OSAL_RETURN_CODE_ENUM OSALLL_eRemoveDirect(
    OSAL_LL_INFO_STRUCT *psInfo,
    OSAL_LINKED_LIST_ENTRY hEntry
        );

static OSAL_LL_ELEMENT_STRUCT *OSALLL_psSearch(
    OSAL_LL_ELEMENT_STRUCT *psList,
    void *pvData,
    OSAL_LL_COMPARE_HANDLER _n16Compare
        );

static OSAL_LL_ELEMENT_STRUCT *OSALLL_psSortedSearch(
    OSAL_LL_ELEMENT_STRUCT *psList,
    void *pvData,
    OSAL_LL_COMPARE_HANDLER _n16Compare
        );

static OSAL_LL_ELEMENT_STRUCT *OSALLL_psSortedBinarySearch(
    OSAL_LL_INFO_STRUCT *psInfo,
    void *pvData,
    OSAL_LL_COMPARE_HANDLER _n16Compare
        );

static OSAL_LL_ELEMENT_STRUCT *OSALLL_psNextSearchPoint (
    OSAL_LL_ELEMENT_STRUCT *psStart,
    BOOLEAN bForward,
    size_t tCount
        );

static OSAL_LL_ELEMENT_STRUCT *OSALLL_psSortedMerge(
    OSAL_LL_ELEMENT_STRUCT *psEntry1,
    OSAL_LL_ELEMENT_STRUCT *psEntry2,
    OSAL_LL_COMPARE_HANDLER tn16Compare
        );

static OSAL_RETURN_CODE_ENUM OSALLL_eAllocateAndAddDirect (
    OSAL_LL_INSERT_ENUM eHow,
    OSAL_OBJECT_HDL hLL,
    OSAL_LL_INFO_STRUCT *psInfo,
    OSAL_LINKED_LIST_ENTRY *phEntry,
    void *pvData
        );

static OSAL_RETURN_CODE_ENUM OSALLL_eAllocateAndAdd (
    OSAL_LL_INSERT_ENUM eHow,
    OSAL_OBJECT_HDL hLL,
    OSAL_LINKED_LIST_ENTRY *phEntry,
    void *pvData
        );

static OSAL_LL_ELEMENT_STRUCT *OSALLL_psAllocateEntry(
    OSAL_LL_INFO_STRUCT *psInfo,
    void *pvData
        );

static OSAL_RETURN_CODE_ENUM OSALLL_eLockDirect(
    OSAL_OBJECT_STRUCT *psObj
        );

static OSAL_RETURN_CODE_ENUM OSALLL_eUnlockDirect(
    OSAL_OBJECT_STRUCT *psObj
        );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

  /***************/
 /** VARIABLES **/
/***************/

#endif    // _OSAL_LL_H_
