/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_GENERAL_H_
#define _OSAL_GENERAL_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"
#include "osal_general.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef enum osalg_notify_type_enum
{
    OSALG_NOTIFY_SLEEP,
    OSALG_NOTIFY_WAKEUP,
    OSALG_NOTIFY_SHUTDOWN

} OSALG_NOTIFY_TYPE_ENUM;

typedef struct osalg_return_code_map_struct
{
    OSAL_RETURN_CODE_ENUM eReturnCode;
    const char *pacText;

} OSALG_RETURN_CODE_MAP_STRUCT;

typedef struct osalg_section_association_struct
{
    size_t tCounter; // Hold count (should never be > 1
    OSAL_OBJECT_HDL hTask; // Holding task handle
    const char *pacTaskName; // Holding task name

} OSALG_SECTION_ASSOCIATION_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

static const OSALG_RETURN_CODE_MAP_STRUCT gsReturnCodeMap[] =
{
    // Informational return codes
    { OSAL_SUCCESS, MACRO_TO_STRING(OSAL_SUCCESS) },
    { OSAL_TIMEOUT, MACRO_TO_STRING(OSAL_TIMEOUT) },
    { OSAL_MESSAGE_NOT_AVAILABLE, MACRO_TO_STRING(OSAL_MESSAGE_NOT_AVAILABLE) },
    { OSAL_QUEUE_EMPTY, MACRO_TO_STRING(OSAL_QUEUE_EMPTY) },
    { OSAL_QUEUE_FULL, MACRO_TO_STRING(OSAL_QUEUE_FULL) },
    { OSAL_QUEUE_MESSAGE_ALREADY_QUEUED, MACRO_TO_STRING(OSAL_QUEUE_MESSAGE_ALREADY_QUEUED) },
    { OSAL_SEM_AVAILABLE, MACRO_TO_STRING(OSAL_SEM_AVAILABLE) },
    { OSAL_SEM_NOT_AVAILABLE, MACRO_TO_STRING(OSAL_SEM_NOT_AVAILABLE) },
    { OSAL_TIMER_NOT_ACTIVE, MACRO_TO_STRING(OSAL_TIMER_NOT_ACTIVE) },
    { OSAL_NO_OBJECTS, MACRO_TO_STRING(OSAL_NO_OBJECTS) },
    { OSAL_OBJECT_NOT_FOUND, MACRO_TO_STRING(OSAL_OBJECT_NOT_FOUND) },

    // Error return codes
    { OSAL_ERROR, MACRO_TO_STRING(OSAL_ERROR) },
    { OSAL_ERROR_CANNOT_CREATE_OBJECT, MACRO_TO_STRING(OSAL_ERROR_CANNOT_CREATE_OBJECT) },
    { OSAL_ERROR_CANNOT_DELETE_OBJECT, MACRO_TO_STRING(OSAL_ERROR_CANNOT_DELETE_OBJECT) },
    { OSAL_ERROR_CANNOT_ADD_OBJECT, MACRO_TO_STRING(OSAL_ERROR_CANNOT_ADD_OBJECT) },
    { OSAL_ERROR_CANNOT_REMOVE_OBJECT, MACRO_TO_STRING(OSAL_ERROR_CANNOT_REMOVE_OBJECT) },
    { OSAL_ERROR_INVALID_INPUT, MACRO_TO_STRING(OSAL_ERROR_INVALID_INPUT) },
    { OSAL_ERROR_CORRUPTED_OBJECT_LIST, MACRO_TO_STRING(OSAL_ERROR_CORRUPTED_OBJECT_LIST) },
    { OSAL_ERROR_INVALID_POINTER, MACRO_TO_STRING(OSAL_ERROR_INVALID_POINTER) },
    { OSAL_ERROR_INVALID_HANDLE, MACRO_TO_STRING(OSAL_ERROR_INVALID_HANDLE) },
    { OSAL_ERROR_NAME_TOO_LONG, MACRO_TO_STRING(OSAL_ERROR_NAME_TOO_LONG) },
    { OSAL_ERROR_NO_FREE_HANDLES, MACRO_TO_STRING(OSAL_ERROR_NO_FREE_HANDLES) },
    { OSAL_ERROR_NAME_NOT_FOUND, MACRO_TO_STRING(OSAL_ERROR_NAME_NOT_FOUND) },
    { OSAL_ERROR_DUPLICATE_NAME, MACRO_TO_STRING(OSAL_ERROR_DUPLICATE_NAME) },
    { OSAL_ERROR_INVALID_PRIORITY, MACRO_TO_STRING(OSAL_ERROR_INVALID_PRIORITY) },
    { OSAL_ERROR_ADDRESS_MISALIGNED, MACRO_TO_STRING(OSAL_ERROR_ADDRESS_MISALIGNED) },
    { OSAL_ERROR_TASK_NOT_REGISTERED, MACRO_TO_STRING(OSAL_ERROR_TASK_NOT_REGISTERED) },
    { OSAL_ERROR_INVALID_TIME, MACRO_TO_STRING(OSAL_ERROR_INVALID_TIME) },
    { OSAL_ERROR_UNSUPPORTED_API, MACRO_TO_STRING(OSAL_ERROR_UNSUPPORTED_API) },
    { OSAL_ERROR_UNSUPPORTED_OPTION, MACRO_TO_STRING(OSAL_ERROR_UNSUPPORTED_OPTION) },
    { OSAL_ERROR_UNSUPPORTED_FLAG, MACRO_TO_STRING(OSAL_ERROR_UNSUPPORTED_FLAG) },
    { OSAL_ERROR_OUT_OF_MEMORY, MACRO_TO_STRING(OSAL_ERROR_OUT_OF_MEMORY) },
    { OSAL_ERROR_LIST_NOT_EMPTY, MACRO_TO_STRING(OSAL_ERROR_LIST_NOT_EMPTY) },
    { OSAL_ERROR_LIST_ITEM_NOT_UNIQUE, MACRO_TO_STRING(OSAL_ERROR_LIST_ITEM_NOT_UNIQUE) },
    { OSAL_ERROR_TIMER_ACTIVE, MACRO_TO_STRING(OSAL_ERROR_TIMER_ACTIVE) },
    { OSAL_ERROR_MESSAGE_NOT_ALLOCATED, MACRO_TO_STRING(OSAL_ERROR_MESSAGE_NOT_ALLOCATED) },
    { OSAL_ERROR_MATH_OVERFLOW, MACRO_TO_STRING(OSAL_ERROR_MATH_OVERFLOW) },
    { OSAL_ERROR_MATH_DIVIDE_BY_ZERO, MACRO_TO_STRING(OSAL_ERROR_MATH_DIVIDE_BY_ZERO) },
    { OSAL_ERROR_TASK_MONITOR_REPORT_TIMEOUT, MACRO_TO_STRING(OSAL_ERROR_TASK_MONITOR_REPORT_TIMEOUT) },
    { OSAL_ERROR_TASK_MONITOR_STACK_EXCEEDED, MACRO_TO_STRING(OSAL_ERROR_TASK_MONITOR_STACK_EXCEEDED) },
    { OSAL_ERROR_TASK_MONITOR_MEMORY_ALLOCATION_EXCEEDED, MACRO_TO_STRING(OSAL_ERROR_TASK_MONITOR_MEMORY_ALLOCATION_EXCEEDED) },
    { OSAL_ERROR_TASK_MONITOR_CPU_UTILIZATION_EXCEEDED, MACRO_TO_STRING(OSAL_ERROR_TASK_MONITOR_CPU_UTILIZATION_EXCEEDED) },
    { OSAL_ERROR_TASK_MONITOR_DEVICE_DRIVER_FAILURE, MACRO_TO_STRING(OSAL_ERROR_TASK_MONITOR_DEVICE_DRIVER_FAILURE) },
    { OSAL_ERROR_UNKNOWN, MACRO_TO_STRING(OSAL_ERROR_UNKNOWN) }

};

#if OSAL_DEBUG == 1
// These are only useful if we are debugging.
static OSALG_SECTION_ASSOCIATION_STRUCT volatile gsCritical = {0, NULL, NULL};
static OSALG_SECTION_ASSOCIATION_STRUCT volatile gsTaskSafe = {0, NULL, NULL};
#endif

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static BOOLEAN OSALG_bNotifyTask ( void *pvData, void *pvArg );
#ifdef OSAL_TEST_CRITICAL_SECTION
#if OSAL_DEBUG == 1
static void vTestEnterSection (
    OSALG_SECTION_ASSOCIATION_STRUCT volatile *psSection);
static void vTestExitSection (
    OSALG_SECTION_ASSOCIATION_STRUCT volatile *psSection);
#endif
#endif

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_GENERAL_H_
