/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_DEVICES_H_
#define _OSAL_DEVICES_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"
#include "osal_stdio.h"

  /***************/
 /** CONSTANTS **/
/***************/

// The maximum number of device drivers which can be registered
#define DEV_MAX_DEVICE_NODES (16)

// The definition of an initialized device entry
#define DEV_NODE_INIT                                           \
{                                                               \
    /*.acDevName = */{0},                                       \
    /*.sInterface = */{NULL,NULL,NULL,NULL,NULL,NULL,NULL},     \
    /*.sShared = */{                                            \
        /*.hMutex = */OSAL_INVALID_OBJECT_HDL,                  \
        /*.pvProperties = */NULL,                               \
        /*.pvPublicData = */NULL,                               \
        /*.un32OpenCount = */0,                                 \
            }                                                   \
}

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct dev_node_shared_struct
{
    // Device Mutex, controls access to internal structures by
    // multiple instances of a device.
    OSAL_OBJECT_HDL hMutex;

    // A pointer to any device specific attribute data
    void *pvProperties;

    // A pointer to any 'node' device node data
    void *pvPublicData;

    // An open() counter
    UN32 un32OpenCount;

} DEV_NODE_SHARED_STRUCT;

/*
    This is the standard device driver internal structure for all device
    drivers. This structure implements a standard interface to all
    drivers for implemeting common driver operations.

    There is one and only one node structure for each device
    that is registered (node).
*/
typedef struct dev_node_struct
{
    // The registered device driver name (include nul)
    char acDevName[OSAL_DEV_MAX_NAME_LENGTH_WITH_NULL];

    // A copy of the device's interface
    OSAL_DEV_INTERFACE_STRUCT sInterface;

    // Device node shared data
    DEV_NODE_SHARED_STRUCT sShared;

} DEV_NODE_STRUCT;

/*
    This is the device driver structure used
    to track an instance of a driver (via hOpen())
    There may be multiple device driver structures for
    each device (multiple open's) all instances of the same
    device map to one and only one node structure
*/
typedef struct dev_struct
{
    // The node this driver instance belongs to
    DEV_NODE_STRUCT *psNode;

    // A copy (to this instance) of any node, public or private
    // data which may be required by the driver's instance.
    OSAL_DEV_INFO_STRUCT sInfo;

} DEV_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

// Local prototypes which implement 'helper' services
static DEV_NODE_STRUCT *DEV_psFindNode (const char *pcDevName);

  /***************/
 /** VARIABLES **/
/***************/

// A declaration containing an initialized driver entry
const DEV_NODE_STRUCT gsNodeInit = DEV_NODE_INIT;

// A local array of registered device drivers
DEV_NODE_STRUCT gasDevices[DEV_MAX_DEVICE_NODES] =
{
    DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT,
    DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT,
    DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT,
    DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT, DEV_NODE_INIT
    // Since not every compiler fills incomplete structure definitions
    // (gcc definitely does not), we need to fill it ourselves.
    // TODO: check warning in this place once DEV_MAX_DEVICE_NODES is
    //       updated
};

// Device Implementation of stdio methods
const OSAL_FILE_INTERFACE_STRUCT GsDeviceIntf =
{
    (void* (*)(const char *pcFileName, const char *pcMode))DEV_hOpen, // fopen
    (int (*)(void *psFile))DEV_n32Close, // fclose
    (size_t (*)(void *pvDst, size_t tSize, size_t tNumObj, void *psFile))DEV_tRead, // fread
    (size_t (*)(const void *pvSrc, size_t tSize, size_t tNumObj, void *psFile))DEV_tWrite, // fwrite
    (long (*)(void *psFile))NULL, // ftell
    (int (*)(void *psFile, int iCmd, va_list *ptList))DEV_n32vIoctl, // ioctl
    (int (*)(void *psFile, long lOffset, int iMode))DEV_n32Seek, // fseek
    (int (*)(const char *pcFileName))NULL, // remove
    (int (*)(const char *pcOldFileName, const char *pcNewFileName))NULL, // rename
    (int (*)(void *psFile))NULL, // fflush
    (int (*)(void *psFile))DEV_n32Error, // ferror
    (int (*)(void *psFile))DEV_n32Eof, // feof
    (void (*)(void *psFile))DEV_vClearerror // clearerr
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_DEVICES_H_
