/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*   LOCAL HEADER
*******************************************************************************/

#if OSAL_DEBUG == 1

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DEBUG_TASK_H_
#define _DEBUG_TASK_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal.h"

#include "osal_debughandler.h"


  /***************/
 /** CONSTANTS **/
/***************/

#define DEBUG_TAB                       (0x09)
#define DEBUG_BACKSPACE                 (0x08)
#define DEBUG_BLANK_SPACE               (0x20)
#if defined (OS_WIN32) || defined (OS_WINCE)
#define DEBUG_LINE_FEED                 (0x0D)
#define DEBUG_CARRIAGE_RETURN           (0x0A)
#else
#define DEBUG_LINE_FEED                 (0x0A)
#define DEBUG_CARRIAGE_RETURN           (0x0D)
#endif
#define DEBUG_PROMPT                    (0x3E)

#define DEBUG_TASK_OPTIONS              (OSAL_TASK_OPTION_DEBUG_OUTPUT)
#define DEBUG_TASK_STACK_SIZE           (8192) // bytes
#define DEBUG_TASK_REPORTING_INTERVAL   (30) // seconds
#define DEBUG_INPUT_MSG_BUFFER_SIZE     (128)  // bytes
#define DEBUG_TASK_INPUT_MSG_BLOCKS     (2)    // msgs
#define DEBUG_TASK_INPUT_MSG_LENGTH     (DEBUG_INPUT_MSG_BUFFER_SIZE + 1)

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct debug_handler_struct
{
    // The task handle this handler is for
    OSAL_OBJECT_HDL         hTask;

    // A handle to this handler's entry in the LL
    OSAL_LINKED_LIST_ENTRY  hMyEntry;

    // Node name
    char *pacName;

} DEBUG_HANDLER_STRUCT;

typedef struct debug_execute_handler_struct
{
    // Flags of the searching criteria
    BOOLEAN bIsIndex;

    // Searching criteria
    union
    {
        struct
        {
            // Entry in the linked list to execute
            UN32 un32EntryNumber;

            // Current iteration index within the linked list
            UN32 un32Index;
        } sIndex;
        struct
        {
            const char *pacName;
        } sName;
    } uCriteria;

    // Pointer to the found DEBUG handler
    DEBUG_HANDLER_STRUCT *psDebugHandler;

} DEBUG_EXECUTE_HANDLER_STRUCT;

typedef struct debug_task_resp_processing_struct
{
    char *pacBufferPtr;
    char *pacBufferStartPtr;
    char *pacBufferEndPtr;

    // A copy of the command being processed
    char acCommand[DEBUG_TASK_INPUT_MSG_LENGTH];

} DEBUG_TASK_INPUT_MSG_PROCESSING_STRUCT;

typedef struct debug_handler_info_struct
{
    OSAL_OBJECT_HDL hSubSystemHdl;
    OSAL_DEBUG_HANDLER CallBackFunct;

} DEBUG_HANDLER_INFO_STRUCT;

typedef struct debug_shared_ctrl_struct
{
    // NOTE: You must obtain the hDebugMutex to read/write the
    // following elements

    // Debug Control Structure Mutex
    OSAL_OBJECT_HDL hDebugMutex;

    // Linked list of Debug Handlers for Registered Tasks
    OSAL_OBJECT_HDL hDebugHandlerList;

    // The Handler used in Single Task Debug Mode
    DEBUG_HANDLER_STRUCT *psSelectedHandler;

} DEBUG_SHARED_CTRL_STRUCT;

typedef struct debug_task_control_struct
{
    // Task Handle
    OSAL_OBJECT_HDL hTask;

    // Install semaphore
    OSAL_OBJECT_HDL hInstallSemaphore;

    // Response Text Queue
    OSAL_OBJECT_HDL hTaskInputQueue;

    // A structure used to process response messages
    DEBUG_TASK_INPUT_MSG_PROCESSING_STRUCT sInputMsg;

    // Shared data
    DEBUG_SHARED_CTRL_STRUCT sShared;

} DEBUG_TASK_CONTROL_STRUCT;

#if OSAL_REMOTE_CONSOLE == 1
typedef struct debug_handler_iterator_struct {
    FILE *psFile;
    UN8 un8Counter;
} DEBUG_HANDLER_ITERATOR_STRUCT;
#endif

  /***************/
 /** VARIABLES **/
/***************/

static DEBUG_TASK_CONTROL_STRUCT gsDebugTaskControl;

  /************/
 /** MACROS **/
/************/

#define DEBUG_NODE_NAME_STRING OSAL_NAME_PREFIX"Dbg Node Name"

  /****************/
 /** PROTOTYPES **/
/****************/

static N32 DEBUG_n32Task( void *pvArg );
static void DEBUG_vPrompt( void );
static BOOLEAN DEBUG_bTaskInitialize( void );
static void DEBUG_vTaskUninitialize( void );
static void DEBUG_vPrintBanner( void );
static BOOLEAN DEBUG_bPrintRegisteredTask ( void *pvData, void *pvArg );
#if OSAL_REMOTE_CONSOLE == 1
static BOOLEAN DEBUG_bFileRegisteredTask ( void *pvData, void *pvArg );
#endif
static void DEBUG_vProcessInputMsgNormalMode( char *pacCmd );
static void DEBUG_vProcessInputMsgSingleTaskMode(
    char *pacCmd,
    OSAL_OBJECT_HDL hTask
        );
static void DEBUG_vDestroyNode(void *pvData);
static DEBUG_HANDLER_STRUCT *DEBUG_psCreateNode( const char *pacName );
static N16 DEBUG_n16Compare( void *pvDH1, void *pvDH2);
static BOOLEAN DEBUG_bCtrlTaskOutput ( void *pvData, void *pvArg );
static DEBUG_HANDLER_STRUCT *DEBUG_psFindDebugHandler( void );
static BOOLEAN DEBUG_bThrowAwayCommand ( void );
static void DEBUG_vSleepHandler( void *pvArg );
static void DEBUG_vWakeupHandler( void *pvArg );
static void DEBUG_vShutdownHandler( void *pvArg );
static BOOLEAN DEBUG_bUpdateHandlerName(
    DEBUG_HANDLER_STRUCT *psDebugHandler,
    const char *pacName
        );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _DEBUG_TASK_H_

#endif // OSAL_DEBUG == 1


