/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *  This module contains the device driver implementation for
 *  a SiriusXM Receiver Module (SRM) X65
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _X65_DRIVER_H_
#define _X65_DRIVER_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"
#include "osal.h"

// Sirius Generic SRH Driver Includes
#include "srh.h"
#include "sms_fcsxm.h"

  /***************/
 /** CONSTANTS **/
/***************/

// These are installed hardware specific definitions
#define X65_NUM_OF_SRMS         (1)
#define X65_NUM_OF_MODULES      (1)
#define X65_NUM_OF_DECODERS     (1)
#define X65_NUM_OF_ANTENNAS     (1)
#define X65_NUM_OF_SDTP_PORTS   (0)
#define X65_DEVICE_GROUP        (7)

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

void SRH_vEnablePower( void );
void SRH_vDisablePower( void );
void SRH_vEnableAntenna( void );
void SRH_vDisableAntenna( void );
void SRH_vEnableReset( void );
void SRH_vDisableReset( void );

  /***************/
 /** VARIABLES **/
/***************/

// This structure is filled out according to specific installed hardware
SRH_DEVICE_DECODER_MAP_STRUCT gasDecoderMap[X65_NUM_OF_DECODERS] =
{
    // The X65 SRM has one module (module 0) with 1 decoder.
    // the decoders for this module are listed here

    // Module 0 Decoder 0
    {
        "Audio",
        0,
        SRH_DEVICE_CAPABILITY_AUDIO | SRH_DEVICE_CAPABILITY_DATA,
        NULL
    },
};

SRH_DEVICE_MODULE_MAP_STRUCT gasModuleMap[X65_NUM_OF_MODULES] =
{
  // Module 0
  {
      0,
      TRUE,
      // SXi Module Configuration
      {
          /* un8Fade = */                  1, /* == Enabled */
          /* un8CategoryLabelLength =   */ 2, /* == 16 characters */
          /* un8ChannelLabelLength =    */ 2, /* == 16 characters */
          /* un8MetadataLabelLength =   */ 2, /* == 16 characters */
          /* un8MaxPendingIndications = */ 1, /* == 4 indications */
          /* un8ConfirmationWaitTime =  */ 0, /* == 200 ms */
          /* un8IRControl =             */ 1, /* == Module Manages */
          /* un8IRDeleteOnTune =        */ 1, /* == Delete on Tune / Advanced IR Enabled */
          /* un8IRMarkNewTrack =        */ 1, /* == On Label */
          /* un8ExtendedControl =       */ 3, /* == I2S Master Mode and Content Buffered
                                                    Indications */
          /* un8PrioritySmartFavCnt =   */ 12  /* == 0 */
      },
      X65_NUM_OF_DECODERS,
      &gasDecoderMap[0]
  }
};

SRH_DEVICE_SRM_MAP_STRUCT gasSRMMap [X65_NUM_OF_SRMS] =
{
    //srm:
    {
        //SRM Name
        "srm:",

        // Application control over RESET procedure.
        // If it is set to TRUE, pvReset function for sReset GPIO
        // shall be present!
        // Bosch ID#19: Enable application specific RESET control and provide the routine(below)
        TRUE,

        // Specify GPIO
        //sPower (pvReset pointer is not used)
        {SRH_vEnablePower, SRH_vDisablePower, NULL},

        //sAntenna (pvReset pointer is not used)
        {SRH_vEnableAntenna, SRH_vDisableAntenna, NULL},

        //sReset
        {SRH_vEnableReset, SRH_vDisableReset, fc_sxm_vResetX65},

        X65_NUM_OF_MODULES,
        &gasModuleMap[0],

        X65_NUM_OF_ANTENNAS,

        // Specify Protocol Id and Port
        PROTOCOL_IDENTIFIER_SXI,
        { "radio:", "115200,N,8,1" }
    }

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _X65_DRIVER_H_

