/******************************************************************************/
/*                    Copyright (c) Sirius-XM Satellite Radio Inc.            */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius-XM Satellite Radio Inc.    */
/*                           Proprietary & Confidential	                      */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef DEVICES_H_
#define DEVICES_H_

#ifdef __cplusplus
extern "C" {
#endif


  /**************/
 /** INCLUDES **/
/**************/

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

/*
    Device ioctl group/class id's

    Certain drivers sometimes belong to generalized groups or classes. In
    this case common operations that devices have which belong to a group
    or class can be generalized and supported by drivers which implement
    them. To accomplish this driver group or class commands can be created.
    To help organize these groups or classes, id's can be constructed which
    allow individual class drivers to define the commands which make up the
    groups. The actual commands themselves are defined in a driver class
    header file (under \Projects\Devices\) but the group ID's are defined here.

    Each device class is given 256 possible entries.
*/

// Media 'device' ioctl group id
#define DEV_IOCTL_MEDIA                      (0x00000200)

// LBA 'device' ioctl group id
#define DEV_IOCTL_LBA                        (0x00000300)

// Widget 'device' ioctl group id
#define DEV_IOCTL_WIDGET                     (0x00000400)

// COM 'device' ioctl group id
#define DEV_IOCTL_COM                        (0x00000500)

// SRH 'device' ioctl group id
#define DEV_IOCTL_SRH                        (0x00000600)

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#ifdef __cplusplus
}
#endif

#endif	// DEVICES_H_
