/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio Inc.                      */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio Inc.           */
/*                           Proprietary & Confidential	                      */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*DESCRIPTION
*
*	This file contains the OSAL start-up code.
*
*******************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

#include "standard.h"
#include "osal.h"

#include "TestTask.h"

static BOOLEAN bStartHandler(const void *pvArg);

// OSAL Start Handlers
static const OSAL_START_HANDLER_STRUCT gsStartHandlers =
{
    // OSAL Driver Registration Handlers
    NULL,
    NULL,
    NULL,

    // OSAL Start Handler
    bStartHandler,
    NULL,

    // OSAL Monitor Handlers
    {
        NULL,
        NULL,

        NULL,
        NULL,

        NULL,
        NULL,
        NULL,
        NULL
    }
};

/*****************************************************************************
*
*       bStartHandler
*
*****************************************************************************/
static BOOLEAN bStartHandler(const void *pvArg)
{
	printf("OSAL Start Handler Function ENTER\n");

	// Anything to start here? Put it here.

    // Install the OSAL Port Test Task
    TESTTASK.eTaskInstall( OSAL_TASK_PRIORITY_HIGH );

	printf("OSAL Start Handler Function EXIT\n");

	return TRUE;
}

/*****************************************************************************
*
*       main
*
*****************************************************************************/
int main(int argc, char *argv[])
{
	BOOLEAN bOsalStarted;
	int iRetval = EXIT_FAILURE;

	bOsalStarted = OSAL.bStart(&gsStartHandlers);
	if(bOsalStarted == TRUE)
	{
	    iRetval = EXIT_SUCCESS;
	}

	return iRetval;
}

