/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _POSIX_SERIAL_H_
#define _POSIX_SERIAL_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <termios.h>

#include "standard.h"
#include "osal.h"
#include "com.h"

#include "posix_serial.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

// Posix Serial device public data structure. This is a local structure for which a
// single instance is created and accessible to ALL instances of Posix Serial Devices
typedef struct posix_serial_public_struct
{
	// Device name on platform (from node properties)
	const char *pacDeviceName;

	// File descriptor
    int fd;

    // Statistics
    COM_IOCTL_STATISTICS_STRUCT sStats;

    // Signal Callback
    COM_SIGNAL_CALLBACK_HDLR pvSignalCallback;
    void *pvSignalCallbackArg;

    // since there is only one instance allowed per connection
    // we don't need to have a private data structure and therefore
    // we can put these flags in the public structure
    N32 n32Error;
    N32 n32Eof;

} POSIX_SERIAL_PUBLIC_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static BOOLEAN _bInit (
                        const char *pcDevName,
                        void const *pvProperties,
                        void **ppvPublicData
                        );

static void _vExit (
                        void const *pvProperties,
                        void *pvPublicData
                        );

static N32 _n32Open (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const void *pvArg
                        );

static N32 _n32Close (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo
                        );

static size_t _tRead (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        char *pcDst,
                        size_t tSize,
                        size_t tNumObjs
                        );

static size_t _tWrite (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const char *pcSrc,
                        size_t tSize,
                        size_t tNumObjs
                        );

static N32 _n32Ioctl (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        N32 n32Cmd,
                        va_list *ptList
                        );

static BOOLEAN _bInitTermSettings (
    struct termios *termios_p
        );

static BOOLEAN _bParseArg (
    const char *pcArg,
    struct termios *termios_p
    );

static void _vSetSignals(POSIX_SERIAL_PUBLIC_STRUCT *psPublicData, UN8 un8Signals);
static UN8 _un8GetSignals(POSIX_SERIAL_PUBLIC_STRUCT *psPublicData);
static void _vClrSignals(POSIX_SERIAL_PUBLIC_STRUCT *psPublicData, UN8 un8Signals);

  /***************/
 /** VARIABLES **/
/***************/
#ifdef __WINCE__
extern int errno;
#endif

// Declaration (external) for the Posix Serial driver interface
const OSAL_DEV_INTERFACE_STRUCT GsPosixSerialInterface =
{
    /*.bInit = */   _bInit,
    /*.vExit = */   _vExit,
    /*.n32Open = */ _n32Open,
    /*.n32Close = */_n32Close,
    /*.tRead = */   _tRead,
    /*.tWrite = */  _tWrite,
    /*.n32Ioctl = */_n32Ioctl
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _POSIX_SERIAL_H_
