/******************************************************************************/
/*                    Copyright (c) Sirius-XM Satellite Radio Inc.            */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius-XM Satellite Radio Inc.    */
/*                           Proprietary & Confidential	                      */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS CLI header file.
 *
 ******************************************************************************/

#ifndef SMS_CLI_H_
#define SMS_CLI_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "standard.h"
#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct smsd_interface_struct
{
    /* Object Members */

    OSAL_RETURN_CODE_ENUM (*eTaskInstall)(
        OSAL_TASK_PRIORITY_ENUM ePriority,
        const char *pacDefaultSMSConfigPath,
        const char *pacDefaultCLIResourcesPath,
        const char *pacDefaultSRHDrvName
            );

    void (*vTaskUninstall) ( void );

    void (*vFullStart) ( void );

} SMSD_INTERFACE_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

extern const SMSD_INTERFACE_STRUCT SMSD;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/


#ifdef __cplusplus
}
#endif

#endif /* SMS_CLI_H */
