/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_wsalerts_types.h
* @brief       Declaration of the Weather Alert Types and includes the SMS API
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_WSALERTS_TYPES_H
#define FC_SXM_WSALERTS_TYPES_H

#include "fc_sxm_sms.h"


// SMS-default sort-method must have number 0
typedef enum
{
   fc_sxm_enWsAlertSortMethod_NONE = 0,
   fc_sxm_enWsAlertSortMethod_DISTANCE,
   fc_sxm_enWsAlertSortMethod_PRIORITY
} fc_sxm_tenWsAlertSortMethod;

typedef enum
{
   fc_sxm_enWsAlertsFilterMethod_NONE = 0,
   fc_sxm_enWsAlertFilterMethod_WSALERTS,
   fc_sxm_enWsAlertMsgTypeInvalid
} fc_sxm_tenWsAlertFilterMethod;


// filter-configuration must provide operator!=
struct fc_sxm_trWsAlertDSRLFilterCfg {
   fc_sxm_tenWsAlertFilterMethod enWsAlertsMsgObjectType;
    // to check if filter has changed, configuration has to provice operator!= 
    tBool operator!=(fc_sxm_trWsAlertDSRLFilterCfg const &b) const {
        SXM_RET_1_IF_NEQ(enWsAlertsMsgObjectType);
        return FALSE;
    }

};


#endif
