/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_wsalerts_properties.h
* @brief       Declaration of the Weather and Security Alert service properties
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/
/*=============================================================================
=======                            DEFINES                              =======
=============================================================================*/
#ifndef FC_SXM_TCL_WSALERTS_PROPERTIES_H
#define FC_SXM_TCL_WSALERTS_PROPERTIES_H

/*=============================================================================
=======                            INCLUDES                             =======
=============================================================================*/
#include "fc_sxm_property.h"
#include "fc_sxm_wsalerts_fi.h"

/*=============================================================================
=======                             TYPES                               =======
=============================================================================*/
/*
  Semaphore-protected data of weather security alerts-app
*/

// example for property, where fi-type is stored directly in member "oFiMsg"

struct fc_sxm_tcl_trWsAlertsPropertyNewUpdateWSAlertsInfoListStatus {
    fc_sxm_tcl_trWsAlertsPropertyNewUpdateWSAlertsInfoListStatus(tBool bUpdateWsAlert_= FALSE)
    {
        (void)bUpdateWsAlert_;
    }
    tBool operator!=(fc_sxm_tcl_trWsAlertsPropertyNewUpdateWSAlertsInfoListStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus oFiMsg;
};

struct fc_sxm_tcl_trWsAlertsPropertyCurrentWSAlertsStatus {
   fc_sxm_tcl_trWsAlertsPropertyCurrentWSAlertsStatus(tBool bUpdateWsAlert_= FALSE)
   {
       (void)bUpdateWsAlert_;
   }
   tBool operator!=(fc_sxm_tcl_trWsAlertsPropertyCurrentWSAlertsStatus const& b) const
   {
       return !(oFiMsg==b.oFiMsg);
   }
   midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus oFiMsg;
};

struct fc_sxm_tcl_trWsAlertsPropertySxmServiceStatus {
  fc_sxm_tcl_trWsAlertsPropertySxmServiceStatus()
        {}
        bool operator!=(fc_sxm_tcl_trWsAlertsPropertySxmServiceStatus const& b) const
        {
            return !(oFiMsg==b.oFiMsg);
        }
        midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
    };

struct fc_sxm_tcl_trWsAlertsPropertyWSAlertAnnounceStatus {
   fc_sxm_tcl_trWsAlertsPropertyWSAlertAnnounceStatus()
        {}
        bool operator!=(fc_sxm_tcl_trWsAlertsPropertyWSAlertAnnounceStatus const& b) const
        {
            return !(oFiMsg==b.oFiMsg);
        }
        midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus oFiMsg;
    };

struct fc_sxm_tcl_trWsAlertsPropertyWeatherAlertData {
   fc_sxm_tcl_trWsAlertsPropertyWeatherAlertData()
        {}
        bool operator!=(fc_sxm_tcl_trWsAlertsPropertyWeatherAlertData const& b) const
        {
            return !(oFiMsg==b.oFiMsg);
        }
        midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus oFiMsg;
    };

struct fc_sxm_tcl_trWsAlertsPropertySxmListMode {
	fc_sxm_tcl_trWsAlertsPropertySxmListMode()
        {}
        bool operator!=(fc_sxm_tcl_trWsAlertsPropertySxmListMode const& b) const
        {
            return !(oFiMsg==b.oFiMsg);
        }
        midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus oFiMsg;
    };

/*=============================================================================
=======                              CLASSES                            =======
=============================================================================*/
class fc_sxm_tclWsalerts_properties:
     public fc_sxm_tclSingleton<fc_sxm_tclWsalerts_properties>
{
   friend class fc_sxm_tclSingleton<fc_sxm_tclWsalerts_properties>;
   public:

   fc_sxm_tclAutoProperty<fc_sxm_tcl_trWsAlertsPropertyNewUpdateWSAlertsInfoListStatus,
   CCA_C_U16_SRV_SXM_WEATHER_ALERTS, /*the service-id of the CCA-Service */
   MIDW_EXT_SXM_WSALERTSFI_C_U16_WSALERTSINFOLISTSTATUS /* give FID if notification to service is needed  */
   > oNewUpdateWSAlertsInfoListStatus;

   fc_sxm_tclAutoProperty<fc_sxm_tcl_trWsAlertsPropertyCurrentWSAlertsStatus,
   CCA_C_U16_SRV_SXM_WEATHER_ALERTS, /*the service-id of the CCA-Service */
   MIDW_EXT_SXM_WSALERTSFI_C_U16_CURRENTWSALERTS /* give FID if notification to service is needed  */
   > oCurrentWSAlertsStatus;

   fc_sxm_tclAutoProperty<fc_sxm_tcl_trWsAlertsPropertySxmServiceStatus,
   CCA_C_U16_SRV_SXM_WEATHER_ALERTS, /*the service-id of the CCA-Service */
   MIDW_EXT_SXM_WSALERTSFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
   > oSxmServiceStatus;

   fc_sxm_tclAutoProperty<fc_sxm_tcl_trWsAlertsPropertyWSAlertAnnounceStatus,
   CCA_C_U16_SRV_SXM_WEATHER_ALERTS, /*the service-id of the CCA-Service */
   MIDW_EXT_SXM_WSALERTSFI_C_U16_WSALERTANNOUNCESTATUS /* give FID if notification to service is needed  */
   > oWSAlertAnnounceStatus;

   fc_sxm_tclAutoProperty<fc_sxm_tcl_trWsAlertsPropertyWeatherAlertData,
   CCA_C_U16_SRV_SXM_WEATHER_ALERTS, /*the service-id of the CCA-Service */
   MIDW_EXT_SXM_WSALERTSFI_C_U16_WEATHERALERTDATA /* give FID if notification to service is needed  */
   > oWeatherAlertData;

   fc_sxm_tclAutoProperty<fc_sxm_tcl_trWsAlertsPropertySxmListMode,
      CCA_C_U16_SRV_SXM_WEATHER_ALERTS, /*the service-id of the CCA-Service */
	  MIDW_EXT_SXM_WSALERTSFI_C_U16_SXMLISTMODE /* give FID if notification to service is needed  */
      > oSxmListMode;

};

#endif
