/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_traffic_data.h
* @brief       Declaration for traffic data class and defines traffic message details.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef FC_SXM_TCL_TRAFFIC_DATA_H
#define FC_SXM_TCL_TRAFFIC_DATA_H

#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_traffic_types.h"
#include "fc_sxm_traffic_fi.h"



class fc_sxm_tclTrafficApp;

/*****************************************************************************
******                           DEFINES                                ******
******************************************************************************/
#define SXM_TRAFFIC_SIZEOF_TMC_MESSAGE    25
#define SXM_TRAFFIC_SIZEOF_SINGLE_GRP_TMC_MSG 5
#define SXM_TRAFFIC_SIZEOF_MULTI_GRP_TMC_MSG  25
#define SXM_SIZEOF_SDTP_PCKT                  1024
#define SXM_TRAFFIC_ALERTC_START_OFFSET   5
#define SXM_SINGLE_GRP_MSG_INDCTN         0x01
#define SXM_MULTI_GRP_MSG_INDCTN          0x00
#define SXM_MAX_MULTIGRP_ALERTC_MSG       4
#define SXM_MULTIGRP_FG_MSG_INDCTN        0x80
#define SXM_MULTIGRP_SG_MSG_INDCTN        0x80

#define SXM_MGM_SUBSQENT_GSI_VALUE_ZERO   0x00
#define SXM_MGM_SUBSQENT_GSI_VALUE_ONE    0x01
#define SXM_MGM_SUBSQENT_GSI_VALUE_TWO    0x02
#define SXM_MGM_SUBSQENT_GSI_VALUE_THREE  0x03
#define SXM_MGM_MNIMUM_SIZE               10
#define SXM_MGM_MAXIMUM_SIZE              25
#define SXM_TRAFFIC_PROGRAMSERVICENAME    " "
#define SXM_TRAFFIC_SERVICEPROVIDERNAME   " "
#define SXM_TRAFFIC_PROGRAM_ID            255

/*****************************************************************************
******                           structures                               ****
******************************************************************************/
/* data structure for LTN message details */
typedef struct trSXMTrafficMessageDetails
{
    /* Location table number*/
    tU8 u8LTN;
    /* Broadcast Service Area set to FALSE, not handled */
    tU16 u16BSA;
    tU8 u8CountryCode;
    /* always FALSE as we are not handling */
    tBool bDuplicate;
    /* not handled so set to FALSE*/
    tBool bStartflag;
    /* flag to trac the multiple sdtp packets */
    tBool bAllMsgTransmitted;
} trSXMTrafficMessageDetails;

/* data structure for alert-c messages */
typedef struct 
{
    tU32 u32SizeOfAlert8Msg;
    tU8 u8AlertCMessage [SXM_TRAFFIC_SIZEOF_TMC_MESSAGE];
} trSXMAlertCmessage;

/* data structure to store messages received from SXM */
struct trSXMTrafficMessage
{
    /*This data structure contains the SXM traffic message details*/
    trSXMTrafficMessageDetails rSXMTrafficMessageDetails;
    /*List to store list of alertc messages */
    list <trSXMAlertCmessage>  qoTrafficAlertCMessage;
};

/* data structure to store Multiple SDTP messages received from SXM */
struct trSXMTrafficSDTPPacket
{
    /* size of each SDTP packet */
    tU32 u32Size;
    /* array to store the SDTP packet */
    tU8 u8Data[SXM_SIZEOF_SDTP_PCKT];
};

/* data structure to store Multiple SDTP packets
   based on the Incident and S&F flow messages */
struct trSXMIncidentAndSFMessage
{
    /* queue to store the Incident msgs */
    queue<trSXMTrafficSDTPPacket>qMultipleIncidentSDTP;
    /* queue to store the S&F msgs */
    queue<trSXMTrafficSDTPPacket>qMultipleSFSDTP;
};

/* 
 * Class fc_sxm_tclTrafficData to handle all traffic related data 
 
 */
class fc_sxm_tclTrafficData:public fc_sxm_tclSingleton<fc_sxm_tclTrafficData>
{
    /**************************************************************************
                         public section                          
    ***************************************************************************/
    public:

        /* Class destructor */
        ~fc_sxm_tclTrafficData();

        /* member function to set the RdbidList */
        tVoid vSetRdbid(trTrafficRdbidList const *poTrafficRdbidList);
        /* meber function to get the stored rdbid list */
        tVoid vGetRdbidList(trTrafficRdbidList & rTrafficRdbidList);
        /* meber function to get the tmc data list */
        tVoid vGetTMCData(sxm_tclMsgFID_TRAFFIC_G_TmcDataStatus& rTmcDataStatus, tBool &bDataForRdbIdComplete);
        /* parse the payload */
        tVoid vParsePayloadData(fc_sxm_trMsgDataPayLoad rMsg);
        /* parse the payload */
        tVoid vParseAndStorePayloadData(fc_sxm_trMsgDataPayLoad rMsg);
        /* store the alert-c message */
        tVoid vStoreAlertCMsg(trSXMTrafficMessage const &rSXMTrafficMessage);

        /* parse the alert-c msg */
        tVoid vParseAlertCMsg(tU8 u8Market,
                                        tBool bSpeedFlowMsg,
                                        tBool bIncidentMsg);

        /* store the alert-c msg */
        tVoid vExtractAlertCMsg(trSXMTrafficMessage &rTrafficMessage,
                               tU8 const *pu8AlertCMessage,tU32 u32AlertCMsgSize) const;
        /* utility functions */
        tVoid vReadyToSendTMC(tVoid);
        /* use to get the country code for the LTN */
        tU8 u8GetCountryCode(tU8 u8Ltn);
         /* check for the completion of tmc data */
        tVoid vSetTmcDataCompleted(tBool);
        
        tBool bIsTmcDataCompleted(tVoid);

        /* receive the alert c msg from sms */
        tVoid vReciveAllertCMsg(OSAL_BUFFER_HDL pvPayload,tU8 u8Market);
        /* clear the old payload packet */
        tVoid vClearOldData(tU8 u8Ltn);
        tVoid vHandleNoSignal(tVoid);
        tBool bIsLTNInRdbidList(tU8 u8LTN);
        // clears the traffic service data during low voltage scenario
        tVoid vClearTrafficServiceData();
        

    /****************************************************************************
    *                     private section                                       *
    ****************************************************************************/
    private:

        /**************************Friend Classes*********************************/
        friend class fc_sxm_tclSingleton<fc_sxm_tclTrafficData>;
        
        /*  Member Functions */

        /* Class constructor */
        fc_sxm_tclTrafficData();

        /************************* Member Variables***************************/

        typedef struct 
        {
            tU16 u16Bsa;
            tU8  u8CountryCode;
        } trBsaAndCountryCode;

        multimap<tU8, trBsaAndCountryCode>_mmapRdbid;
        /* this is the queue to store traffic messages within an active set
           to prepare a complet active set */
        queue<trSXMTrafficMessage > _qTrafficMessage;
        /* to store the traffic messages */
        trSXMTrafficMessage _oReadyToSendTMC;
        tBool _bTmcDataSentCompleted;
        /* to store multiple sdtp packets */
        map<tU8,trSXMIncidentAndSFMessage>_mMultipleSdtpMsg;
        

        
 
    /**************************************************************************
    *                          protected section                              *
    ***************************************************************************/
    protected:


};

#endif /*FC_SXM_TCL_TRAFFIC_DATA_H */

