/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_traffic_app.h
* @brief       Defines the tarffic app handler class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_TRAFFIC_APP_H_
#define _FC_SXM_TCL_TRAFFIC_APP_H_

#include "fc_sxm_traffic_fi.h"
#include "fc_sxm_tcl_data_app.h"
#include "fc_sxm_tcl_traffic_types.h"


/*****************************************************************************
******                           DEFINES                                ******
******************************************************************************/

#define FC_SXM_DATASERVICE_TRAFFIC_DSI_ID  480
#define FC_SXM_TRAFFIC_DEFAULT_TMCDATA_UPDATE_PERIOD  1000  // in ms


/*****************************************************************************
******                           structures                               ****
******************************************************************************/

/* Messages from SMS-Callbacks */
struct fc_sxm_trMsgDataTrafficSmsEvtServiceState: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Traffic, 200);

    DATASERVICE_STATE_ENUM eState;
};

// method-start from cca-service
struct fc_sxm_trMsgTrafficMStartSetRdbIdWishList: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Traffic, 205);
    fc_sxm_trAdressing rAdressing;
    sxm_tcl_MsgFID_TRAFFIC_S_SetRdbIdMethodStart oFiMsg;

};

/* Messages from SMS-Callbacks */
struct fc_sxm_trMsgTrafficDataPayLoad: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Traffic, 204);

    OSAL_BUFFER_HDL pvPayload;
};

/* messages send for timer concept */
struct fc_sxm_trMsgTMCDataTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Traffic, 206);
};

/*
  the traffic-app class
*/
class fc_sxm_tclTrafficApp : 
public fc_sxm_tclDataApp,
    public fc_sxm_tclSingleton<fc_sxm_tclTrafficApp>
    
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclTrafficApp>;
    friend class fc_sxm_tclTimer<fc_sxm_tclTrafficApp, 
                                         fc_sxm_trMsgTMCDataTimer>;

 public:

    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Traffic;

    /* Destructor */
    virtual ~fc_sxm_tclTrafficApp();
    /* Initialize the traffic service */
    virtual tVoid vInitialize(tVoid);
    /* DeInitialize the traffic service */
    virtual tVoid vDeInitialize(tVoid);
    /* dispatch thread-messages specific for traffic-app */
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);
    /* send the tmc data to tima */
    tVoid vPostTmcData(tVoid);
    /* update the tmc data status */
    tVoid vTmcDataReady(tVoid);
    /* post the rdbid actual list to tima */
    tBool bPostRdbIdActualList(midw_fi_tcl_e8_TunerReceptionState::tenType enReceptionState);
    /* start timer */
    tVoid vStartTMCDataTimer(tVoid);
	/* timer checking */
    tBool bIsTmcDataTimerRunning(tVoid) const;
	/* to notify timeout */
    tVoid vTmcdataTimerNotifyTimeOut(tVoid);
    /* state change informed by framework */
    virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);
    /* parses the payload header */
    tBool bParseServiceSpecificPayloadHeader(OSAL_BUFFER_HDL pvPayload,
                                fc_sxm_trMsgDataPayLoad &rTrafficPayloadMsg);

protected:
    /* set the DMI based on the location id */
    tBool bSetDmi(trTrafficRdbidList const  *rTrafficRdbidList);
    /* to start the data service */
    SXM_SMS_DATASRV_ACCESS(DATA, _hTraffic);

    tVoid vProcessGenericMsg(fc_sxm_trMsgCmdDataAppSignalState const *prMsg);
    tVoid vProcessGenericMsg(fc_sxm_trMsgCmdDataAppAntennaState const *prMsg);
    //over ridden from data app to clear the old data during re-initialization of sms service.
    tVoid vClearServiceData(tVoid);

    /* commands From CCA-Thread: */
    /* Start the service (Mandatory, dispatched by Base-Class) */
    virtual tVoid vStartSmsService();

 private:
    /* ttfis-cmds */
    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);
    
    /* Messages created in SMS-Callbacks */


    /* Process to start the payload parsing */
    //virtual tVoid vProcess(fc_sxm_trMsgTrafficDataPayLoad const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgDataPayLoad const *prMsg);


    /* messages specific for traffic-app go from here */
    /* fi-messages */
    virtual tVoid vProcess(fc_sxm_trMsgTrafficMStartSetRdbIdWishList const *prMsg);
    virtual tVoid vProcessTimer(fc_sxm_trMsgTMCDataTimer const *prMsg);

    /* post the state and mode operation state to fi */
    tVoid vPostStateAndOperationMode(tVoid) const;
 
    /* Constructor */
    fc_sxm_tclTrafficApp();
    
    tBool bModifyFilter(tBool bEnable, SXM_DMI tDMI);
    /* member variables */

    DATASERVICE_MGR_OBJECT _hTraffic;
    DSI _u16Dsi;
    /* flag to store the condition of SXM traffic(  Up/Down (TRUE/FALSE) */
    tBool _bIsSXMTrafficUp;
    tBool _bRdbListActive;
    tBool _bSetDMI;
    /* queue to maintain the LTN list */
    queue<trLTN > _qLtn;
    /* member to store the state and operation mode */
    /* tuner state mode(no, off, no data,...). */
    sxm_tcl_e8_TunerState::tenType _enTunerState;
    /* tuner operation mode(no signal , SXM deactivated, 
                                  service deactivated ,...). */
    sxm_tcl_e8_OperationMode::tenType _enOperationMode;
    /* Timer to handle to update TMCData */
    fc_sxm_tclTimer<fc_sxm_tclTrafficApp, 
                          fc_sxm_trMsgTMCDataTimer> _mTMCDataUpdateTimer;
};

#endif //_FC_SXM_TCL_TRAFFIC_APP_H_
